

open import Utils.Logic hiding (<-ℕ-wf)

module CNF.NullableSound (N T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) where


open import Relation.Nullary
open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect)

open import Data.List
open import Data.Nat hiding (_≟_)
open import Data.Bool hiding (_∨_ ; _≟_ ; T)
open import Data.Product
open import Data.Sum

open import Utils.ListsAddition
open import Utils.ListMembership
open import Utils.ListProperties

open import CNF.Grammar N T _=n_ _=t_
open import CNF.ParseTree N T _=n_ _=t_
open import CNF.Nullable N T _=n_ _=t_
open import CNF.NullableUtility N T _=n_ _=t_

open DecExistance hiding (_∈?_)
open WF<


mutual 
 addRule : {R : Rules}{A B : N}{xs : List T}{ws : Symbols} → Tree R A xs 
                                        → Tree ((B , ws) ∷ R) A xs
 addRule {R} {A} {B} {xs} {ws} (node {xs₁} x x₁) 
   = node (there x) (addRule'  {R} {B} {xs} {_} {ws}  x₁)
 

 addRule' : {R : Rules}{B : N}{ys : List T}{xs ws : Symbols} 
   → ListOfTs R xs ys → ListOfTs ((B , ws) ∷ R) xs ys
 addRule' ⟦⟧ = ⟦⟧
 addRule' {R} {B} (t ∷t l) = t ∷t addRule' {R}  {B} l
 addRule' {R}  {B} (x ∷n l) = _∷n_ (addRule x) (addRule' {R} {B} l)


soundZ : {A : N}(R : Rules) → A ∈ nlbls R 0 → (A , []) ∈ R
soundZ [] ()
soundZ {A} (x ∷ R) p with incLem  {N} {A} {null-f [] x} {nlbls R 0}  p 
soundZ ((x , x₁) ∷ R) p | inj₁ x₂ with inspect (allIn x₁ [])
... | it true p1 rewrite p1 | incSngl x₂ | allInEmpt x₁ p1 = here
... | it false p1 rewrite p1 with x₂
... | ()
soundZ {A} (x ∷ R) p | inj₂ x₁ = there (soundZ {A} R x₁)

open import Utils.NatProperties
-- Big troubles with termination because of the non-existance of
-- sub-runs of the run (solved by inner induction on AllIn structure)
mutual
  sound : {A : N}(n : ℕ) →  WF.Acc _<_ n → (R : Rules) 
                         → A ∈ nlbls R n → Tree R A []
  sound zero wf [] ()
  sound {A} zero wf ((x , x₁) ∷ R) p 
    with incLem {_} {A} 
         {(if allIn x₁ [] then x ∷ [] else [])} 
         {nlbls R 0} p
  sound {A} zero wf ((x , x₁) ∷ R) p 
   | inj₁ e with inspect (allIn x₁ [])
  sound {A} zero wf ((x , x₁) ∷ R) p 
   | inj₁ e 
   | it true p1 rewrite allInEmpt x₁ p1 
   | incSngl  e = node here ⟦⟧
  sound {A} zero wf ((x , x₁) ∷ R) p 
   | inj₁ e 
   | it false p1 rewrite p1 with e
  ... 
   | ()
  sound {A} zero wf ((x , x₁) ∷ R) p 
   | inj₂ e = node (there (soundZ R e)) ⟦⟧
  sound {A} (suc n) wf [] ()
  sound {A} (suc n) wf (r ∷ R) p 
    with foldlth N (_=n_) A (r ∷ R) 
         (null-f (nlbls (r ∷ R) n)) p
  sound {A} (suc n) wf (r ∷ R) p  
   | (B , ws) , proj2 , proj3 
    with inspect 
         (allIn ws (nlbls (r ∷ R) n))
  sound {A} (suc n) wf (r ∷ R) p  
   | (B , ws) , proj2 , proj3 
   | it false p1 rewrite p1 with proj3
  ... | ()
  sound {A} (suc n) (acc wf) (r ∷ R) p  
   | (B , ws) , proj2 , proj3 
   | it true p1 
   with allInSound ws (nlbls (r ∷ R) n) p1 
  sound (suc n) (WF.acc wf) (r ∷ R) p 
   | (B , .[]) , proj2 , proj3 
   | it true p1 
   | all_c1 rewrite incSngl proj3 = node proj2 ⟦⟧
  sound (suc n) (WF.acc wf) (r ∷ R) p 
   | (B , .(inj₁ x ∷ xs)) , proj2 , proj3 
   | it true p1 
   | all_c2 {x} {xs} q x₁ with sound n (wf n (refl≤ (suc n))) (r ∷ R) x₁  
   | sound' n (wf n (refl≤ (suc n))) xs (r ∷ R) q
  sound (suc n) (WF.acc wf) (r ∷ R) p 
   | (B , .(inj₁ x ∷ xs)) , proj2 , proj3 
   | it true p1 
   | all_c2 {x} {xs} q x₁ 
   | d  
   | tree 
   with x ∈? nlbls (r ∷ R) n ∧ 
        allIn xs (nlbls (r ∷ R) n)
  sound (suc n) (WF.acc wf) (r ∷ R) p 
   | (B , .(inj₁ x ∷ xs)) , proj2 , proj3 
   | it true p1 
   | all_c2 {x} {xs} q x₁ 
   | d  
   | tree 
   | true rewrite incSngl proj3 = node proj2 (_∷n_ d tree)
  sound (suc n) (WF.acc wf) (r ∷ R) p 
   | (B , .(inj₁ x ∷ xs)) , proj2 , proj3 
   | it true p1 
   | all_c2 {x} {xs} q x₁ 
   | d  
   | tree 
   | false with proj3
  ... | () 


  sound' : (n : ℕ) → WF.Acc _<_ n → (ws : Symbols) →  (R : Rules) 
                     →  AllIn ws (nlbls R n)  → ListOfTs R ws []
  sound' n wf .[] R all_c1 = ⟦⟧
  sound' n wf .(inj₁ x ∷ xs) R (all_c2 {x} {xs} ai x₁) 
    = _∷n_ (sound n wf R x₁) (sound' n wf xs R ai)


nlbls-snd :  {A : N}(n : ℕ) → (R : Rules) 
             → A ∈ nlbls R n → Tree R A []
nlbls-snd n R c = sound n (<-ℕ-wf n) R c
