
open import Utils.Logic

module CNF.ParseTree (N T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) where

open import Relation.Nullary
open import Relation.Binary.PropositionalEquality hiding ([_])

open import Data.List hiding (all)
open import Data.List.All hiding (all)
open import Data.List.Properties
open import Data.Product
open import Data.Sum 
open import Data.Empty
open import Data.Nat hiding (_≟_)

open import Utils.ListsAddition
open import Utils.ListMembership
open import Utils.ListProperties

open import CNF.Grammar N T _=n_ _=t_


mutual 
  data Tree (Rs : Rules) : N → List T → Set where
     node : ∀ {xs ys n} → (n , xs) ∈ Rs 
                        → ListOfTs Rs xs ys → Tree Rs n ys

  data ListOfTs (Rs : Rules) : Symbols → List T → Set where
    ⟦⟧    : ListOfTs Rs [] []
    _∷t_  : ∀ {xs ys} → (t : T) → ListOfTs Rs xs ys
                      → ListOfTs Rs (inj₂ t ∷ xs) (t ∷ ys)
    _∷n_  : ∀ {xs ys n zs} → Tree Rs n zs → ListOfTs Rs xs ys
                      → ListOfTs Rs (inj₁ n ∷ xs) (zs ++ ys)

