

module CNF.README where

-- Definition of productions of context-free grammar and 
-- general context-free grammars.
import CNF.Grammar

-- Definition of inductive datatype for parse trees for general CFGs.
import CNF.ParseTree

-- Calculating the nullable nonterminals (+ soudness and completeness profos).
import CNF.Nullable
import CNF.NullableComplete
import CNF.NullableSound

-- Elimination of epsilon rules (+ languages preservation and progress).
import CNF.NormEpsRules

-- Elimination of unit rules (+ languages preservation and progress).
import CNF.NormUnitRules

-- Elimination of rules with terminals at the RHS 
-- (+ languages preservation and progress).
import CNF.NormTermRules

-- Elimination of long rules (+ languages preservation and progress).
import CNF.NormLongRules

-- Preservation of progress by transformations.
import CNF.NormInvariants

-- Overall progress, soundness and completeness.
import CNF.NormCorrectness

-- Normalization of a CFG with the starting nonterminal.
import CNF.NormGrammar

-- Example of grammar normalization.
import CNF.NormExample

