

open import Utils.Logic

import CYK.GrammarCNF as CYKG

module CYK.Completeness  (N : Set)(T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T)
  (G : CYKG.GrammarCNF N T _=n_ _=t_) where

open CYKG N T _=n_ _=t_
open GrammarCNF G

open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect)
open import Relation.Nullary

open import Data.Product hiding (map)
open import Data.Nat  hiding (_<_ ; _*_) renaming (_≟_ to _?=_) 
open import Data.List
open import Data.Bool hiding (T)
open import Data.Empty

open import CYK.ParseTree N T _=n_ _=t_ G 
open import CYK.ParseTreeWrapper N T _=n_ _=t_ G 
open import CYK.Power N T _=n_ _=t_ G 
open import CYK.TriplesStruct

open import Utils.Logic
open import Utils.ListProperties
open import Utils.ArithmeticProperties
open import Utils.ListMonad


sngl-rhs-rules-com :  ∀ {A t Rs} → (prf : (A ─> t) ∈ Rs) → (A , prf) ∈ sngl-rhs-rules t Rs
sngl-rhs-rules-com {A} {t} {Rs}  prf 
   with list-monad-ht (A , prf)  (∈-lst Rs) 
        (λ { (p₁ , p₂) → sngl-help p₁ p₂ t }) 
        (A ─> t , prf) (∈-lst-complete (A ─> t) Rs prf)
... | p with (t =t t) 
sngl-rhs-rules-com prf | p₁ | yes refl = p₁ here
sngl-rhs-rules-com prf | p  | no ¬p    = ex-falso-quodlibet (¬p refl)


rhs-rules-com :  ∀ {A B C Rs} → (prf : (A ─> B ∙ C) ∈ Rs) 
  → (A , prf) ∈ rhs-rules B C Rs
rhs-rules-com {A} {B} {C} {Rs} prf 
   with list-monad-ht (A , prf) (∈-lst Rs) 
        (con-help B C) (A ─> B ∙ C , prf) 
        (∈-lst-complete (A ─> B ∙ C)  Rs prf) 
rhs-rules-com {A} {B} {C} {Rs} prf | p  with B =n B | C =n C  
rhs-rules-com {A} {B} {C} {Rs} prf | p₂ | yes refl | yes refl = p₂ here
rhs-rules-com {A} {B} {C} {Rs} prf | p₁ | yes p | no ¬p = ex-falso-quodlibet (¬p refl)
rhs-rules-com {A} {B} {C} {Rs} prf | p | no ¬p | dec2   = ex-falso-quodlibet (¬p refl)


asc-ls-comp : ∀ {k n} → (i : ℕ) → k < n → (i + k) ∈ (asc-ls i n) 
asc-ls-comp {n} {zero} i ()
asc-ls-comp {k} {(suc n)} i lss = 
  elth  k  0 (i + k) (asc-ls i (suc n)) 
        (subst (λ ind → k < ind) (sym (asc-ls-len i (suc n))) lss) 
        (asc-ls-el k (suc n) i lss) 

subs-comp : (t : T) → (ts : List T) → ∀ i → (sub : Substring1 t ts i) 
   → (t , sub) ∈ (subs i ts)
subs-comp t .(t ∷ xs) .0 (scon1 {xs}) = here
subs-comp t .(y ∷ xs) .(suc i) (scon2 {y} {xs} {i} sub) with subs-comp t xs i sub
... | IH with ∃-split (t , sub) (subs i xs) IH 
... | p1 , p2 , p3 rewrite p3 | subs-lft-thm {y} p1 ((t , sub) ∷ p2)  
  = ∈-weak-lft {_} {subs-lft p1} {(t , scon2 sub) ∷ subs-lft p2} {(t , scon2 sub)} here

-- _*_ is complete
*-complete :  ∀ {A B C i k j s} → (t1 : s [ i , k [◂ B)
 → (t2 : s [ k , j [◂ C)
 → (Q1 Q2 : Mtrx s)
 → (i , k , B , t1) ∈ Q1  
 → (k , j , C , t2) ∈ Q2  
 → (x : (A ─> B ∙ C) ∈ Rs )
 → (i , j , A , cons x t1 t2) ∈ (Q1 * Q2)
*-complete {A} {B} {C} {i} {k} {j} {s} t1 t2 Q1 Q2 in1 in2 rin 
  with list-monad-ht (i , j , A , cons rin t1 t2) Q2 
                     (λ {(_ , _ , _ , t₃) → t1 ** t₃ }) 
                     (k , j , C , t2) in2 
... | w with k ?= k 
*-complete {A} {B} {C} {i} {k} {j}  t1 t2 Q1 Q2 in1 in2 rin | w | yes refl 
   = list-monad-ht (i , j , A , cons rin t1 t2) Q1
                   (λ {(_ , _ , _ , t₁) → 
                   Q2 >>= λ {(_ , _ , _ , t₂) → t₁ ** t₂}})
                   (i , k , B , t1) in1 
                   (w (list-monad-ht  (i , j , A , cons rin t1 t2)  
                                      (rhs-rules B C Rs)  
                                      (λ { (rhs , prf) → [ _ , _ ,  _ , cons prf t1 t2 ] })
                                      (A , rin) (rhs-rules-com rin) here))
*-complete t1 t2 Q1 Q2 in1 in2 rin | w | no ¬p = ex-falso-quodlibet (¬p refl)

complete-empty : ∀ {s} → (st : N) → (i : ℕ)
  → (t : s [ i , i [◂ st)
  → (p : Nullable? ≡ true)
  → (_ , _ , _ , t) ∈ m-empty s p
complete-empty {s} .Λ-NT .i (empt {i} x x₁) p rewrite uip x p = list-monad-ht (i , i , Λ-NT , empt p x₁)  (desc-ls-< (suc (length s)))   (λ { (x , prf) → [ x , x , Λ-NT , empt p prf ] }) (i , x₁)  (desc-ls-<-comp' i (suc (length s)) x₁) here

complete-empty st .i (cons {i} x t t₁) p with cyktree-lem0 _ _ _ _ t | cyktree-lem0 _ _ _ _ t₁ 
... | p1 | p2 rewrite ≤≥≡ _ _ p1 p2 with cyktree-lem1 t₁ 
... | o rewrite o = ex-falso-quodlibet (Λ-NT-Rule2 x) 



-- main completeness theorem
complete : ∀ {s} → (st : N) → (n i j  : ℕ) → (accn : Acc n) 
  → (i ≡ j → ⊥)
  → (t : s [ i , j [◂ st)
  → (j ≡ n + i) 
  → (_ , _ , _ , t) ∈ pow (m-init s) n accn
complete .Λ-NT n i .i ij accn (empt x q) prf = ex-falso-quodlibet (accn refl)

-- t = sngl, basically proving that `m-init` is complete
complete  st zero i .(suc i) ij accn (sngl x x₁) ()
complete {s}  st (suc zero) i .(suc i) (acc y) ij (sngl x x₁) prf = 
   list-monad-ht (i , suc i , st , sngl x x₁) (asc-ls 0 (foldr (λ _ → suc) 0 s)) 
                 (λ pos → (subs pos s)        >>=  λ { (t , sub)     → 
                 (sngl-rhs-rules  t Rs)         >>=  λ { (rhs , prf)   → 
                 [ _ , _ , _ , sngl prf sub ] }}) i (asc-ls-comp 0 (subst-lemm x₁))
                 (list-monad-ht (i , suc i , st , sngl x x₁) (subs i s) (λ { (t , sub)  → 
                                (sngl-rhs-rules  t Rs)   >>=  λ { (rhs , prf)   → 
                                [ _ , _ , _ , sngl prf sub ] }}) (_ , x₁) (subs-comp _ s i x₁ )
                                (list-monad-ht (i , suc i , st , sngl x x₁)  (sngl-rhs-rules _ Rs) 
                                               (λ { (rhs , prf) → [ _ , _ , _ , sngl prf x₁ ] }) (st , x)
                                               (sngl-rhs-rules-com x) here))

-- t = sngl, sngl trees cannot appear in 2+i powers of m-init
complete st (suc (suc n)) i .(suc i) accn ij (sngl x x₁) prf 
 rewrite +-comm n i = ex-falso-quodlibet (∸-lemm10  prf) 

--complete st n i .(suc i) accn (sngl x x₁) prf = {!!}
-- t = cons t₂ t₃,  cannot have a `cons t₂ t₃` tree 
-- with  t₂ : CYKTree s G .C 0 j  and t₃ : CYKTree s G .B i 0
complete {s} st n i j accn ij (cons {.i} {zero} x t₂ t₃) prf 
 with cyktree-lem1' t₂
complete {s} st n .0 j accn ij (cons {.0} {zero} x t₂ t₃) prf | refl 
 with cyktree-lem1' t₂ | cyktree-lem3' t₂
complete {s} st n ._ j accn ij (cons {._} {zero} x t₂ t₃) prf | refl | refl | o rewrite o

    = ex-falso-quodlibet (Λ-NT-Rule1 x) 

-- t = cons t₂ t₃, (t₂ : CYKTree s G .C 0 j) =(cyktree-lem2)=> ∃ p1 . j ≡ suc p1 + i
complete {s} st zero i .i accn ij (cons {.i} {suc l} x t₂ t₃) refl with cyktree-lem2' t₂ (ex-falso-quodlibet (ij refl))
-- i ≡ 0 ∧ t₃ : CYKTree s G _ (suc p1) 0 => absurd
complete {s} st zero zero .zero accn ij (cons {.zero} {suc .(p1 + 0)} x t₂ t₃) refl | p1 , refl
 with cyktree-lem1' t₃ 
... | () 

-- t = cons t₂ t₃,  (t₃ : CYKTree s G .C (2 + p1 + i)) (1 + i)) => absurd
complete {s} st zero (suc i) .(suc i) accn ij (cons {.(suc i)} {suc .(p1 + suc i)} x t₂ t₃) refl | p1 , refl
 with cyktree-lem2' t₃ (ex-falso-quodlibet (ij refl))
... | o1 , o2  
  rewrite +-comm (suc p1) (suc i) 
  | sym (+-assoc (suc o1) (suc i) (suc p1)) 
  | +-comm  o1 (suc i) 
  | +-assoc i o1 (suc p1) = ex-falso-quodlibet (∸-lemm10 o2)

-- t = cons t₂ t₃, suc n
complete {s} st (suc n) i j accn ij (cons {.i} {suc j₁} x t₂ t₃) prf 
  with i ?= suc j₁
... | yes pr rewrite pr  = ex-falso-quodlibet (Λ-NT-Rule1 (subst (λ h →  (st ─> h ∙ _) ∈ Rs) (cyktree-lem1 t₂) x))
complete {s} st (suc n) i j accn ij (cons {.i} {suc j₁} x t₂ t₃) prf  | no pr  with suc j₁ ?= suc (n + i)
... | yes pr1 rewrite pr1 | prf = ex-falso-quodlibet (Λ-NT-Rule2 (subst (λ h → (st ─> _ ∙ h) ∈ Rs) (cyktree-lem1 t₃) x))
... | no pr1
  with cyktree-lem2' t₂  pr
  | cyktree-lem2' (subst (λ ind → (s [ (suc j₁) , ind [◂ _ )) prf t₃) pr1 
-- cons in power 1 => absurd
complete {s} st (suc zero) i .(suc i) accn ij (cons {.i} {suc .(p1 + i)} x t t₃) refl | no pr | no pr1 | p1 , refl | q1 , q2 
  rewrite +-comm (suc p1) i 
  | sym (+-assoc q1 i (suc p1)) 
  | +-comm q1 i = ex-falso-quodlibet (∸-lemm11 {i} q2)

-- t = cons t₂ t₃, suc (suc n), main case, described in paper
complete {s} st (suc (suc n)) i j (acc y) ij (cons {.i} {suc .(p1 + i)} .{suc n} .{st} {B} {C} x t₂ t₃) prf | no pr | no pr1
  | p1 , refl | q1 , q2 
  with ∸-lemm9 {suc (suc n)} {i} {suc q1} {suc p1} q2 
complete {s} st (suc (suc n)) i j (acc y) ij (cons  {.i} {suc .(p1 + i)} .{suc n} .{st} {B} {C} x t₂ t₃) prf  | no pr | no pr1
  | p1 , refl | q1 , q2 | arth4p 
  rewrite (trans prf q2) 
  with suc (p1 + i) ?= suc (q1 + suc (p1 + i)) 
... | yes pr2  = ex-falso-quodlibet (Λ-NT-Rule2 (subst (λ h → (st ─> B ∙ h) ∈ Rs) (cyktree-lem1 (subst (λ h → s [ suc (p1 + i) , h [◂ C) (sym pr2) t₃ )) x)) 
... | no pr2 with complete C (suc q1) _ _ 
                (y (suc q1) (<-lemm2 {p1}  arth4p)) pr2 t₃ refl -- inductive hyp 1
  |    complete B (suc p1) _ _ 
                (y (suc p1) (<-lemm3 {p1} arth4p)) pr t₂ refl   -- inductive hyp 2
complete {s} st (suc (suc n)) i j (acc y) ij (cons {.i} {suc .(p1 + i)} .{suc n} .{st} {B} {C} x t₂ t₃) prf | no pr | no pr1 
  | p1 , refl | q1 , q2 | arth4p | no pr2 | IH-t2 | IH-t1 
  = list-monad-ht  (i , suc (q1 + suc (p1 + i)) , st , cons x t₂ t₃) 
                   (triples (suc n)) 
                   (λ { (l₁ , l₂ , l₃) →  
                      (pow (m-init s) (suc l₁) (y (suc l₁) (<-lemm3 {l₁} l₃)))   *
                      (pow (m-init s) (suc l₂) (y (suc l₂) (<-lemm2 {l₁} l₃)))})
                   (p1 , q1 , arth4p)  
                   (triples-complete p1 q1 (suc n) arth4p) 
                   (*-complete t₂ t₃ _ _ IH-t1 IH-t2 x)



complete-full : ∀ {s} → (st : N) → (i n  : ℕ) → (accn : Acc n) 
  → (t : s [ i , n + i [◂ st)
  → (_ , _ , _ , t) ∈ pow (m-init s) n accn
complete-full st i n accn t with (n + i)  ?= i
complete-full st i n accn t | yes p rewrite p | jjn  i n (sym (trans (+-comm i n) p))  with inspect Nullable? 
complete-full st i n accn t | yes p | it true x = complete-empty  _ _ t x
complete-full st i n accn t | yes p | it false x with trans (sym x) (cyktree-lem1` t)
... | ()
complete-full st i n accn t | no  p = complete st n i (n + i) accn (λ pr → p (sym pr)) t refl

