

open import Utils.Logic

module CYK.GrammarCNF (N : Set)(T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) where

open import Relation.Binary.PropositionalEquality hiding ([_])
open import Relation.Nullary

open import Data.Bool hiding (T)
open import Data.List renaming (_++_ to _+++_)
open import Data.Product hiding (map)

open import Utils.ListProperties
open import Utils.ListMonad

data Rule : Set where
 _─>_   : N → T → Rule
 _─>_∙_ : N → N → N → Rule 

Rules : Set
Rules = List Rule


record GrammarCNF : Set where
  constructor ⟨_,_,_,_,_⟩
  field
    Λ-NT : N  
    Nullable? : Bool
    Rs : Rules
    Λ-NT-Rule1 : {A nt : N} → (A ─> Λ-NT ∙ nt) ∉ Rs
    Λ-NT-Rule2 : {A nt : N} → (A ─> nt ∙ Λ-NT) ∉ Rs



-- filtering LHS of first type rules
sngl-help : ∀ {Rs} → (r : Rule) →  r ∈ Rs → (c : T) → List (Σ[ A ∈ N ] (A ─> c) ∈ Rs)
sngl-help (x ─> x₁) c rule with x₁ =t rule
sngl-help (x ─> .rule) c rule | yes refl = [ x , c ]
... | no  p = []
sngl-help (x ─> x₁ ∙ x₂) c rule = []

sngl-rhs-rules : (t : T) → (Rs : Rules) 
  → List (Σ[ A ∈ N ]  (A ─> t) ∈ Rs)
sngl-rhs-rules t Rs = ∈-lst Rs >>= λ pair → sngl-help (proj₁ pair) (proj₂ pair) t


-- filtering LHS second type rules
con-help : ∀ {Rs} → (B C : N) → (Σ[ r ∈ Rule  ] r ∈ Rs) → List (Σ[ A ∈ N ] (A ─> B ∙ C) ∈ Rs)
con-help B C (x ─> x₁ , proj₂) = []
con-help B C (x ─> x₁ ∙ x₂ , proj₂)  with x₁ =n B | x₂ =n C 
con-help B C (x ─> .B ∙ .C , proj₂)  | yes refl | yes refl = [ x , proj₂ ]
con-help B C (x ─> x₁ ∙ x₂ , proj₂)  | yes p | no ¬p = []
con-help B C (x ─> x₁ ∙ x₂ , proj₂)  | no ¬p | dec2 = []

rhs-rules : (B C : N) → (Rs : Rules) → List (Σ[ A ∈  N ] (A ─> B ∙ C) ∈ Rs)
rhs-rules B C Rs = ∈-lst Rs >>= (λ pair → con-help B C pair)
