

open import Utils.Logic

import CYK.GrammarCNF as CYKG

module CYK.MemPower (N : Set)(T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T)
  (G : CYKG.GrammarCNF N T _=n_ _=t_) where

open CYKG N T _=n_ _=t_
open GrammarCNF G

open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect)
open import Relation.Nullary

open import Data.Nat hiding (_<_ ; _*_) 
open import Data.List
open import Data.Bool hiding (_≟_ ; T)
open import Data.Product hiding (map)
open import Data.Empty
open import Data.Maybe

open import CYK.ParseTree N T _=n_ _=t_ G
open import CYK.Power N T _=n_ _=t_ G
open import CYK.TriplesStruct

open import Utils.ArithmeticProperties
open import Utils.ListProperties
open import Utils.ListMonad

-- type synonym for memo table entry 
MemTblEntry : ∀ {s} → Mtrx s → ℕ → Set
MemTblEntry {s} t p = Maybe (Σ[ mt ∈ Mtrx s ] mt ≡ pow t p (<-ℕ-wf p))  

-- type synonym for memo table
MemTbl : ∀ {s} → Mtrx s → Set
MemTbl {s} t = (p : ℕ) → MemTblEntry t p

-- memo table update
memTbl-upd : ∀ {s} → (t : Mtrx s) → MemTbl t → (p : ℕ) 
  → MemTblEntry t p
  → MemTbl t
memTbl-upd t tbl i₁ ent i₂ with i₁ ≟ i₂ 
memTbl-upd t tbl .i₂ ent i₂ | yes refl = ent
memTbl-upd t tbl i₁ ent i₂ | no ¬p = tbl i₂



-- memoized version of `pow` function (does not constructa MemTbl, just uses it)
pow-mem : ∀ {s} → (t : Mtrx s) → (n : ℕ) → MemTbl t → Mtrx s
pow-mem t zero f with inspect Nullable? 
pow-mem t zero f | it true prf = m-empty _ prf 
pow-mem t zero f | it false prf = []
pow-mem t (suc zero)  f = t
pow-mem t (suc n)  f =  (triples n) >>= λ { (l₁ , l₂ , _) →  
      (maybe proj₁ (pow t (suc l₁) (<-ℕ-wf (suc l₁))) (f (suc l₁))) *
      (maybe proj₁ (pow t (suc l₂) (<-ℕ-wf (suc l₂))) (f (suc l₂))) }



-- showing that accessability argument is irrelevant for the result
pow≡mem-sub-accn : ∀ {s} → (t : Mtrx s) → (n : ℕ) → (f : MemTbl t) 
 → (accn1 accn2 : Acc n) 
 → (trpls : List (Σ[ i ∈ ℕ ] Σ[ j ∈ ℕ ] (suc i) + (suc j) ≡ n))   
 → pow-par t n accn1 trpls ≡ pow-par t n accn2 trpls
pow≡mem-sub-accn t zero f accn1 accn2 trpls = refl
pow≡mem-sub-accn t (suc zero) f accn1 accn2 trpls = refl
pow≡mem-sub-accn t (suc (suc n)) f (acc x) (acc x₁) [] = refl
pow≡mem-sub-accn t (suc (suc n)) f (acc x) (acc x₁) ((t1 , t2 , t3) ∷ trpls) 
  with pow≡mem-sub-accn t (suc (suc n)) f (acc x) (acc x₁) trpls  
  | pow≡mem-sub-accn t ((suc t1)) f (x ( (suc t1)) (<-lemm3 t3)) (x₁ (suc t1) (<-lemm3 t3)) (triples t1)
  | pow≡mem-sub-accn t (suc t2) f (x (suc t2) (<-lemm2 {t1} t3)) (x₁ (suc t2) (<-lemm2 {t1} t3)) (triples t2)
  | >>=split [ (t1 , t2 , t3) ] trpls
    (λ {(l₁ , l₂ , l₃) →  
     (pow t (suc l₁) (x (suc l₁) (<-lemm3 {l₁} l₃))) *
     (pow t (suc l₂) (x (suc l₂) (<-lemm2 {l₁}  l₃)))})
  | >>=split [ (t1 , t2 , t3) ] trpls
  (λ {(l₁ , l₂ , l₃) →  
   (pow t (suc l₁) (x₁ (suc l₁) (<-lemm3 {l₁} l₃))) *
   (pow t (suc l₂) (x₁ (suc l₂) (<-lemm2 {l₁}  l₃))) })
... | d1 | d2 | d3 | d4 | d5 rewrite d5 | d4 | d1 | d2 | d3 = refl



-- Acc n is irrelevant for `pow`
pow≡pow-mem-sub-accn : ∀ {s} → (t : Mtrx s) → (n : ℕ) → (f : MemTbl t) 
   → (accn1 accn2 : Acc n)
   → pow t n accn1 ≡ pow t n accn2 
pow≡pow-mem-sub-accn t zero f accn1 accn2 = refl
pow≡pow-mem-sub-accn t (suc zero) f accn1 accn2 = refl
pow≡pow-mem-sub-accn t (suc (suc n)) f (acc x) (acc x₁) 
   = pow≡mem-sub-accn t (suc (suc n)) f (acc x) (acc x₁) (triples (suc n))


-- parsing with MemTbl is correct
pow≡pow-mem-sub : ∀ {s} → (t : Mtrx s) → (n : ℕ) → (f : MemTbl t)
  → (y : (m : ℕ) → m < suc n → Acc m) → ∀ l
  →  (maybe proj₁ (pow t (suc (projTI l)) (<-ℕ-wf (suc (proj₁ l))) ) (f (suc (projTI l)))) *
      (maybe proj₁ (pow t (suc (projTJ l)) (<-ℕ-wf (suc (proj₁ (proj₂ l))))) (f (suc (projTJ l))))
      ≡ 
      (pow t (suc (projTI l)) (y (suc (projTI l)) (<-lemm3 {projTI l} (projTP l))))   *
      (pow t (suc (projTJ l)) (y (suc (projTJ l)) (<-lemm2 {projTI l}  (projTP l))))
pow≡pow-mem-sub t n f y l with (f (suc (projTI l))) | (f (suc (projTJ l)))
pow≡pow-mem-sub t n f y (l1 , l2 , l3) | just (p , pr) | just (x , xp) 
 rewrite pr | xp
 | pow≡pow-mem-sub-accn t (suc l1) f (acc (aux (suc l1))) (y (suc l1) (<-lemm3 l3)) 
 | pow≡pow-mem-sub-accn t (suc l2) f (acc (aux (suc l2))) (y (suc l2) (<-lemm2 {l1} l3)) = refl
pow≡pow-mem-sub t n f y (l1 , l2 , l3) | just (p , pr) | nothing 
 rewrite pr 
 | pow≡pow-mem-sub-accn t (suc l1) f (acc (aux (suc l1))) (y (suc l1) (<-lemm3 l3))
 | pow≡pow-mem-sub-accn t (suc l2) f (acc (aux (suc l2))) (y (suc l2) (<-lemm2 {l1} l3)) = refl
pow≡pow-mem-sub t n f y (l1 , l2 , l3) | nothing | just (x , xp)
 rewrite xp
 | pow≡pow-mem-sub-accn t (suc l1) f (acc (aux (suc l1))) (y (suc l1) (<-lemm3 l3))
 | pow≡pow-mem-sub-accn t (suc l2) f (acc (aux (suc l2))) (y (suc l2) (<-lemm2 {l1} l3)) = refl
pow≡pow-mem-sub t n f y (l1 , l2 , l3) | nothing | nothing 
  rewrite 
  pow≡pow-mem-sub-accn t (suc l1) f (acc (aux (suc l1))) (y (suc l1) (<-lemm3 l3))
  | pow≡pow-mem-sub-accn t (suc l2) f (acc (aux (suc l2))) (y (suc l2) (<-lemm2 {l1} l3)) = refl


-- memoized and non-memoized functions give the same results
abstract
  pow≡pow-mem : ∀ {s} → (t : Mtrx s) → (n : ℕ) → (f : MemTbl t) → (accn : Acc n)
     → pow-mem t n f ≡ pow t n accn
  pow≡pow-mem t zero f accn with inspect Nullable? 
  ... | it true  prf = refl
  ... | it false prf = refl
  pow≡pow-mem t (suc zero) f accn = refl
  pow≡pow-mem t (suc (suc n)) f (acc y) = >>=cong 
    (λ { (l₁ , l₂ , l₃) → 
      (maybe proj₁ (pow t (suc l₁) (<-ℕ-wf (suc l₁))) (f (suc l₁))) *
      (maybe proj₁ (pow t (suc l₂) (<-ℕ-wf (suc l₂))) (f (suc l₂)))})
    (λ { (l₁ , l₂ , l₃) →  
        (pow t (suc l₁) (y (suc l₁) (<-lemm3 {l₁} l₃))) *
        (pow t (suc l₂) (y (suc l₂) (<-lemm2 {l₁}  l₃)))})
    (triples (suc n))
    (pow≡pow-mem-sub t (suc n) f y)


-- iteratively fill memo table
pow-mem-itr :  ∀ {s} → (t : Mtrx s) → (n m : ℕ) → (f : MemTbl t) → Mtrx s
pow-mem-itr t n zero f = pow-mem t n f 
pow-mem-itr  t n (suc m) f with inspect (pow-mem t n f)
... | it [] y        = pow-mem-itr t (suc n) m (memTbl-upd t f n 
                        (just ([] , trans (sym y) (pow≡pow-mem t n f (acc (aux n))))))
... | it (x ∷ xs) y  = pow-mem-itr t (suc n) m (memTbl-upd t f n 
                        (just (x ∷ xs , trans (sym y) (pow≡pow-mem t n f (acc (aux n))))))



pow-mem-itr≡pow-mem-itr : ∀ {s} → (t : Mtrx s) → (n m : ℕ) → (f : MemTbl t) 
   → pow-mem-itr t n m f ≡ pow-mem-itr t (m + n) 0 f
pow-mem-itr≡pow-mem-itr t n zero f = refl
pow-mem-itr≡pow-mem-itr t n (suc m) f with inspect (pow-mem t n f) 
pow-mem-itr≡pow-mem-itr t n (suc m) f | it [] x with pow-mem-itr≡pow-mem-itr t (suc n) m (memTbl-upd t f n
       (just ([] , trans (sym x) (pow≡pow-mem t n f (acc (aux n)))))) 
... | IH rewrite +-comm m (suc n) | +-comm n m | pow≡pow-mem t (suc (m + n)) f (<-ℕ-wf (suc (m + n)))  | pow≡pow-mem t (suc (m + n)) (memTbl-upd t f n
       (just ([] , trans (sym x) (pow≡pow-mem t n f (acc (aux n)))))) (<-ℕ-wf (suc (m + n))) = IH

pow-mem-itr≡pow-mem-itr t n (suc m) f | it (y ∷ ys) x with pow-mem-itr≡pow-mem-itr t (suc n) m (memTbl-upd t f n
       (just (y ∷ ys , trans (sym x) (pow≡pow-mem t n f (acc (aux n)))))) 
... | IH rewrite +-comm m (suc n) | +-comm n m | pow≡pow-mem t (suc (m + n)) f (<-ℕ-wf (suc (m + n)))  | pow≡pow-mem t (suc (m + n)) (memTbl-upd t f n
       (just (y ∷ ys , trans (sym x) (pow≡pow-mem t n f (acc (aux n)))))) (<-ℕ-wf (suc (m + n))) = IH


pow-mem-itr≡pow-mem : ∀ {s} → (t : Mtrx s) → (n : ℕ) → (f : MemTbl t) 
   → pow-mem-itr t 0 n f ≡ pow-mem t n f
pow-mem-itr≡pow-mem t n f with pow-mem-itr≡pow-mem-itr t 0 n f 
... | IH rewrite +-comm n 0 = IH


cyk-mem-parse : (s : List T) → Mtrx s
cyk-mem-parse s = pow-mem-itr (m-init s) 0 (length s) (\ _ → nothing)

open import CYK.Completeness N T _=n_ _=t_ G

complete-mem : ∀ s → (st : N) 
  → (t : s [ 0 , length s [◂ st)
  → (_ , _ , _ , t) ∈ cyk-mem-parse s
complete-mem s start t rewrite pow-mem-itr≡pow-mem {s = s} (m-init s) (length s) (\ _ → nothing) 
 | pow≡pow-mem {s = s} (m-init s) (length s) (λ _ → nothing) (<-ℕ-wf (length s))
 with complete-full {s = s} start 0 (length s) (<-ℕ-wf (length s))  
... | pp rewrite +-comm (length s) 0  = pp t


filterFull : (s : List T) → Mtrx s → List (Σ[ A ∈ N ] s [ 0 , length s [◂ A)
filterFull s [] = []
filterFull s ((proj₁ , proj₂ , proj₃) ∷ m) with proj₁ ≟ 0 | proj₂ ≟ (length s) 
filterFull s ((.0 , .(foldr (λ _ → suc) 0 s) , proj₃) ∷ m) | yes refl | yes refl =  proj₃ ∷ filterFull s m 
filterFull s ((proj₁ , proj₂ , proj₃) ∷ m) | yes p | no ¬p = filterFull s m
filterFull s ((proj₁ , proj₂ , proj₃) ∷ m) | no ¬p | yes p = filterFull s m
filterFull s ((proj₁ , proj₂ , proj₃) ∷ m) | no ¬p | no ¬p₁ = filterFull s m

filterFull1 : (s : List T) → (m : Mtrx s ) → (A : N) → (t : s [ 0 , length s [◂ A) → 
   (_ , _ , _ , t) ∈ m → (_ , t) ∈ filterFull s m 
filterFull1 s ((.zero , .(length s) , .a , .t) ∷ m) a t here with zero ≟ 0 | (length s) ≟ (length s)
filterFull1 s ((._ , .(foldr _ _ s) , .a , .t) ∷ m) a t here | yes refl | yes refl = here
filterFull1 s ((._ , .(foldr _ _ s) , .a , .t) ∷ m) a t here | yes p | no ¬p = ex-falso-quodlibet (¬p refl)
filterFull1 s ((._ , .(foldr _ _ s) , .a , .t) ∷ m) a t here | no ¬p | o2 = ex-falso-quodlibet (¬p refl)

filterFull1 s ((proj₁ , proj₂ , proj₃) ∷ m) a t (there pi) with proj₁ ≟ 0 | proj₂ ≟ (length s) 
filterFull1 s ((.0 , .(foldr (λ _ → suc) 0 s) , proj₃) ∷ m) a t (there pi) | yes refl | yes refl = there (filterFull1 s m a t pi)
filterFull1 s ((.0 , proj₂ , proj₃) ∷ m) a t (there pi) | yes refl | no ¬p = (filterFull1 s m a t pi)
filterFull1 s ((proj₁ , .(foldr (λ _ → suc) 0 s) , proj₃) ∷ m) a t (there pi) | no ¬p | yes refl = (filterFull1 s m a t pi)
filterFull1 s ((proj₁ , proj₂ , proj₃) ∷ m) a t (there pi) | no ¬p | no ¬p₁ = (filterFull1 s m a t pi)



simple-parsing : (s : List T) → List (Σ[ A ∈ N ] s [ 0 , length s [◂ A)
simple-parsing s = filterFull s (cyk-mem-parse s)

simple-parsing-complete : (s : List T) → (A : N) → (t : s [ 0 , length s [◂ A) → (A , t) ∈ simple-parsing s
simple-parsing-complete s A t = filterFull1 s _ A t (complete-mem s A t)



filterStart : (s : List T) → List (Σ[ A ∈ N ] s [ 0 , length s [◂ A) → List (s [ 0 , length s [◂ Λ-NT)
filterStart s [] = []
filterStart s ((A , proj₂) ∷ l) with A =n Λ-NT 
filterStart s ((._ , proj₂) ∷ l) | yes refl = proj₂ ∷ filterStart s l
filterStart s ((A , proj₂) ∷ l) | no ¬p = filterStart s l

filterStart1 : (s : List T) → (l : List (Σ[ A ∈ N ] s [ 0 , length s [◂ A)) → (t : s [ 0 , length s [◂ Λ-NT) → 
   (_ , t) ∈ l →  t ∈ filterStart s l 
filterStart1 s ._ t here with Λ-NT =n Λ-NT  
filterStart1 s ._ t here | yes refl = here
filterStart1 s ._ t here | no ¬p = ex-falso-quodlibet (¬p  refl)
filterStart1 s ((A , t') ∷ l) t (there ip) with A =n Λ-NT 
filterStart1 s ((._ , t') ∷ l) t (there ip) | yes refl = there (filterStart1 s l t ip)
filterStart1 s ((A , t') ∷ l) t (there ip) | no ¬p = (filterStart1 s l t ip)


simple-parsing-start : (s : List T) → List (s [ 0 , length s [◂ Λ-NT)
simple-parsing-start s = filterStart s (simple-parsing s) 


simple-parsing-start-complete : (s : List T) → (t : s [ 0 , length s [◂ Λ-NT) → t ∈ simple-parsing-start s
simple-parsing-start-complete s t = filterStart1 s (simple-parsing s) t (simple-parsing-complete s _ _)
