

open import Utils.Logic

import CYK.GrammarCNF as CYKG

module CYK.ParseTree (N : Set)(T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T)
  (G : CYKG.GrammarCNF N T _=n_ _=t_) where

open CYKG N T _=n_ _=t_
open GrammarCNF G

open import Relation.Binary.PropositionalEquality hiding ([_])

open import Data.Nat hiding (_<_)
open import Data.List renaming (_++_ to _+++_)
open import Data.Bool hiding (T)
open import Data.Product

open import Utils.ListProperties
open import Utils.ListMonad
open import Utils.ArithmeticProperties

 
data Substring1 {X : Set} : X → List X → ℕ → Set where
  scon1 : ∀ {xs x}     → Substring1 x (x ∷ xs) 0 
  scon2 : ∀ {y xs i x} → Substring1 x xs i → Substring1 x (y ∷ xs) (suc i) 


data _[_,_[◂_ (s : List T) : ℕ → ℕ → N → Set where
  empt :  ∀{i} → Nullable? ≡ true 
          → i < (1 + length s)
          → s [ i , i [◂ Λ-NT
  sngl : ∀{i A t}
         → (A ─> t) ∈ Rs
         → Substring1 t s i 
         → s [ i , (1 + i) [◂ A
  cons : ∀{i j n A B C}
         → (A ─> B ∙ C) ∈ Rs
         → s [ i , j [◂ B
         → s [ j , n [◂ C
         → s [ i , n [◂ A


-- some tree structure properties
cyktree-lem1' : ∀ {s st i} → s [ i , 0 [◂ st → i ≡ 0
cyktree-lem1'  {xs} .{Λ-NT} .{0} (empt x i<) = refl
cyktree-lem1'   (cons x y' y0 ) 
 rewrite cyktree-lem1'  y0 = cyktree-lem1' y'  


cyktree-lem3' : ∀ {xs A}
 → xs [ 0 , 0 [◂ A → A ≡ Λ-NT
cyktree-lem3' {xs} .{Λ-NT} (empt x i<) = refl
cyktree-lem3' {xs} {A} (cons x t t₁) with cyktree-lem1' t₁ 
cyktree-lem3' {xs} {A} (cons x t t₁) | refl with cyktree-lem3' t 
cyktree-lem3' {xs} {A} (cons x t t₁) | refl | refl 
  = ex-falso-quodlibet (Λ-NT-Rule1 {A} x)

-- generating the list of all substrings
subs-lft : ∀ {X x ts i} → List (Σ[ t ∈ X ] Substring1 t ts i) 
  → List (Σ[ t ∈ X ] Substring1 t (x ∷ ts) (suc i))
subs-lft [] = []
subs-lft ((proj₁ , proj₂) ∷ l) = (proj₁ , scon2 proj₂) ∷ subs-lft l

subs-lft-thm : ∀ {x ts i} → (ls1 ls2 : List (Σ[ t ∈ T ] Substring1 t ts i))
  → subs-lft {_} {x} {ts} {i} (ls1 +++ ls2) ≡ subs-lft ls1 +++ subs-lft ls2
subs-lft-thm [] ls2 = refl
subs-lft-thm (x₁ ∷ ls1) ls2 = cong (_∷_ _) (subs-lft-thm ls1 ls2)


subs : {X : Set} → (i : ℕ) → (ts : List X) → List (Σ[ t ∈ X ] Substring1 t ts i)
subs zero [] = []
subs zero (x ∷ ts) = [ x , scon1 ]
subs (suc i) [] = []
subs (suc i) (x ∷ ts) = subs-lft (subs i ts)

subst-lemm :  ∀ {X : Set} →  {t : X} → ∀ {ts i} → Substring1 t ts i → i < (length ts)
subst-lemm {_} {t} .{(t ∷ xs)} .{0} (scon1 {xs}) = <-0suc (length xs)
subst-lemm {_} {t} .{(y ∷ xs)} .{(suc i)} (scon2 {y} {xs} {i} subs) = <-cong1 (subst-lemm subs)

