

open import Utils.Logic

import CYK.GrammarCNF as CYKG

module CYK.ParseTreeWrapper (N : Set)(T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T)
  (G : CYKG.GrammarCNF N T _=n_ _=t_) where

open CYKG N T _=n_ _=t_
open GrammarCNF G

open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect)
open import Relation.Nullary

open import Data.Nat hiding (_<_)
open import Data.List renaming (_++_ to _+++_)
open import Data.Bool hiding (T ; _≟_)
open import Data.Product hiding (map)
open import Data.Empty

open import Utils.ListProperties
open import Utils.ListMonad
open import Utils.ArithmeticProperties

open import CYK.ParseTree N T _=n_ _=t_ G 


data _◂_  : (s : List T) → N → Set where
  empt' :  Nullable? ≡ true → [] ◂ Λ-NT
  sngl' : ∀{A t} → (A ─> t) ∈ Rs
           → [ t ] ◂ A
  cons' : ∀{A B C s₁ s₂}
         → (A ─> B ∙ C) ∈ Rs
         → s₁ ◂ B
         → s₂ ◂ C
         → (s₁ +++ s₂) ◂ A


≤≥≡ : ∀ a b → a ≤ b → b ≤ a → a ≡ b
≤≥≡ .0 .0 z≤n z≤n = refl
≤≥≡ .1 .1 (s≤s z≤n) (s≤s z≤n) = refl
≤≥≡ .(suc (suc m)) .(suc (suc m₁)) (s≤s (s≤s {m} ab)) 
  (s≤s (s≤s {m₁} ba)) rewrite ≤≥≡ _ _ ab ba = refl


cyktree-lem0 : ∀ s st i j → s [ i , j [◂ st  → i ≤ j
cyktree-lem0 s .Λ-NT i .i (empt x p) = kl i
  where
   kl : ∀ a → a ≤ a
   kl zero = z≤n
   kl (suc a) = s≤s (kl a)
cyktree-lem0 s st i .(suc i) (sngl x x₁) = kl i 
  where
   kl : ∀ a → a ≤ suc a
   kl zero = z≤n
   kl (suc a) = s≤s (kl a)
cyktree-lem0 s st i j (cons .{i} {k} x tr tr₁) 
  with cyktree-lem0 s _ i k tr | cyktree-lem0 s _ k j tr₁
... | t | t'  = kl i k j t t'
  where
   kl : ∀ a b c → a ≤ b → b ≤ c → a ≤ c
   kl .0 b c z≤n bc = z≤n
   kl .(suc m) .(suc n) .(suc n₁) (s≤s {m} {n} ab) (s≤s {.n} {n₁} bc) = s≤s (kl _ _ _ ab bc)



cyktree-lem1 : ∀ {s st i} → s [ i , i [◂ st  → st ≡ Λ-NT
cyktree-lem1 (empt x p) = refl
cyktree-lem1 (cons x t t₁) with cyktree-lem0 _ _ _ _ t | cyktree-lem0 _ _ _ _ t₁ 
... | ij | ji rewrite ≤≥≡ _ _ ij ji | cyktree-lem1 t = ex-falso-quodlibet (Λ-NT-Rule1  x)


cyktree-lem1` : ∀ {s st i} → s [ i , i [◂ st  → Nullable? ≡ true
cyktree-lem1` (empt x x₁) = x
cyktree-lem1` (cons x t t₁) with cyktree-lem0 _ _ _ _ t | cyktree-lem0 _ _ _ _ t₁ 
... | ij | ji rewrite ≤≥≡ _ _ ij ji | cyktree-lem1 t = ex-falso-quodlibet (Λ-NT-Rule1 x)


cyktree-lem2 : ∀ {s st i j} → i ≢ j → s [ i , j [◂ st 
  → Σ[ n ∈ ℕ ] j ≡ (suc n + i)
cyktree-lem2 prf (empt x p) = ex-falso-quodlibet (prf refl)
cyktree-lem2 prf (sngl x scon1) = 0 , refl
cyktree-lem2 prf (sngl x (scon2 x₁)) = 0 , refl
cyktree-lem2 prf (cons {i} {j} {k} x tree tree₁) with i ≟ j | j ≟ k
cyktree-lem2 prf (cons x tree tree₁) | yes p | yes p₁ rewrite p | p₁ | cyktree-lem1 tree = ex-falso-quodlibet (Λ-NT-Rule1 x)
cyktree-lem2 prf (cons x tree tree₁) | yes p | no ¬p rewrite p | cyktree-lem1 tree = ex-falso-quodlibet (Λ-NT-Rule1 x)
cyktree-lem2 prf (cons x tree tree₁) | no ¬p | yes p rewrite p | cyktree-lem1 tree₁ = ex-falso-quodlibet (Λ-NT-Rule2 x)
cyktree-lem2 prf (cons x tree tree₁) | no ¬p | no ¬p₁ with cyktree-lem2 ¬p tree | cyktree-lem2 ¬p₁ tree₁ 
... | (o , oprf) | (p , pprf) rewrite pprf | oprf = p + suc o , trans refl (sym (cong suc (+-assoc p (suc o) _)))

cyktree-lem2' : ∀ {s st i j} → s [ i , (suc j) [◂ st  → (i ≡ (suc j) → ⊥) → Σ[ n ∈ ℕ ] (suc j) ≡ (suc n + i)
cyktree-lem2' t p = cyktree-lem2  p t

nf` : ∀ a b → suc a ≤ suc b → a ≤ b
nf` a b (s≤s prf) = prf

nf`` : ∀ a b c → a ≤ b → a ≤ b + c
nf`` .0 b c z≤n = z≤n
nf`` .(suc m) .(suc n) c (s≤s {m} {n} prf) = s≤s (nf`` m n c prf)

nf``` : ∀ a b c → a + b ≤ c → a ≤ c
nf``` zero b c prf = z≤n
nf``` (suc a) b zero ()
nf``` (suc a) b (suc c) (s≤s prf) = s≤s (nf``` a b c prf)

dropdrop : ∀ {X : Set} → (n m : ℕ) → (s : List X) → drop n (drop m s) ≡ drop (n + m) s
dropdrop zero zero [] = refl
dropdrop (suc n) zero [] = refl
dropdrop zero (suc m) [] = refl
dropdrop (suc n) (suc m) [] = refl
dropdrop zero m (x ∷ s) = refl
dropdrop (suc n) zero (x ∷ s) rewrite +-comm n zero = refl
dropdrop (suc n) (suc m) (x ∷ s) rewrite +-comm n (suc m) | +-comm m n = dropdrop (suc n) m s
-- 
takedrop : ∀ {X : Set} → (n m : ℕ) → (s : List X) 
  → take m (drop n s) ≡ drop n (take (n + m) s) 
takedrop zero m s = refl
takedrop (suc n) zero [] = refl
takedrop (suc n) (suc m) [] = refl
takedrop (suc n) m (x ∷ s) = takedrop n m s


droptakedrop : ∀ {X : Set} → (j i n : ℕ) → (s : List X) 
  → drop j (take (j + n) (drop i s)) ≡  take n  (drop (j + i)  s)
droptakedrop i j n s  rewrite takedrop j (i + n) s
 | dropdrop i j (take (j + n) s) | sym (takedrop j (i + n) s)  | sym (takedrop i n (drop j s)) | dropdrop i j s = refl


takelemm : ∀ {X : Set} → (s1 s2 : List X) → take  (length s1) (s1 +++ s2) ≡ s1
takelemm [] s2 = refl
takelemm (x ∷ s1) s2 = cong (_∷_ x) (takelemm s1 s2)


droplemm : ∀ {X : Set} → (s1 s2 : List X) → drop  (length s1) (s1 +++ s2) ≡ s2
droplemm [] s2 = refl
droplemm (x ∷ s1) s2 = droplemm s1 s2


sub : (l : List T) → (i j : ℕ) →  List T
sub xs i n = take n (drop i xs)

sublemma : (l : List T) → sub l 0 (length l) ≡ l
sublemma [] = refl
sublemma (x ∷ l) rewrite sublemma l = refl


subsub' : (i : ℕ) → (t : T) → (l : List T) → Substring1 t l i  → sub l i 1  ≡ [ t ] 
subsub' .0 t .(t ∷ xs) (scon1 {xs}) = refl
subsub' .(suc i) t .(y ∷ xs) (scon2 {y} {xs} {i} s) = subsub' i t xs s


subsub : (i : ℕ) → (t : T) → (l : List T) → sub l i 1  ≡ [ t ] →  Substring1 t l i
subsub zero t [] ()
subsub (suc i) t [] ()
subsub zero t (.t ∷ l) refl = scon1 
subsub (suc i) t (x ∷ l) p = scon2 (subsub i t l p)



takelemm2 : {X : Set} → (j : ℕ) → (l : List X)  →  j ≤ length l -> length (take j l) ≡ j
takelemm2 zero [] p = refl
takelemm2 (suc j) [] ()
takelemm2 zero (x ∷ l) p = refl
takelemm2 (suc j) (x ∷ l) p = cong suc (takelemm2 j l  (nf` j (length l) p))


droplemm2 : {X : Set} → (i : ℕ) → (l : List X)  →  length (drop i l) ≡ length l ∸ i
droplemm2 zero []  = refl
droplemm2 (suc i) []  = refl
droplemm2 zero (x ∷ l)  = refl
droplemm2 (suc i) (x ∷ l)  = droplemm2 i l


nf''' : ∀ a  → a ≤ a 
nf''' zero = z≤n
nf''' (suc a) = s≤s (nf''' a)

nf'' : ∀ a b c → c ≤ b → (a + b) ∸ c ≡ a + (b ∸ c)  
nf'' a b .0 z≤n = refl
nf'' a .(suc n) .(suc m) (s≤s {m} {n} pr) rewrite sym (nf'' a n m pr) | +-comm a (suc n) | +-comm n a = refl
 
mj : ∀ j → j ∸ j ≡ 0
mj zero = refl
mj (suc j) = mj j

m0 : ∀ j → j + 0 ≡ j
m0 zero = refl
m0 (suc j) = cong suc (m0 j)

mio : ∀ i o → i ≤ i + o
mio i zero rewrite +-comm i zero = nf''' i
mio zero (suc o) = z≤n
mio (suc i) (suc o)  = s≤s (mio i (suc o))

nf' : ∀ i j → i ≤ j → Σ[ n ∈ ℕ ] n + i  ≡ j
nf' .0 j z≤n = j , trans (+-comm j 0) refl
nf' .(suc m) .(suc n) (s≤s {m} {n} prf) with nf' m n prf 
... | (o , p) = o , trans (+-comm o (suc m)) (cong suc (trans (+-comm m o) p)) --cong suc p

taketake' : ∀ {X : Set} → (n m : ℕ) → (s : List X)  → take n (take (n + m) s) ≡ take n s
taketake' zero m s = refl
taketake' (suc n) m [] = refl
taketake' (suc n) m (x ∷ s) = cong (_∷_ x) (taketake' n m s)

taketake : ∀ {X : Set} → (n m : ℕ) → (s : List X) → n ≤ m → take n (take m s) ≡ take n s
taketake n m s prf with nf' n m prf 
... | n1 , o rewrite (sym o) | +-comm n1 n = taketake' n n1 s

nf : ∀ i j l →  i + j ≤ l → i ≤ l ∸ j
nf i j l prf with nf' (i + j) l prf 
... | (o , p) rewrite (sym p) | sym (+-assoc o i j) | nf'' (o + i) j j  (nf''' j) | mj j | m0 (o + i) | +-comm o i = mio i o

sublength : ∀ l i n → (i + n ≤ length l) →  length (sub l i n) ≡ n
sublength [] zero zero prf = refl
sublength (x ∷ l) zero zero prf = refl
sublength [] zero (suc n) ()
sublength (x ∷ l) zero (suc n) prf = cong suc (sublength l zero n (nf` n (length l) prf))
sublength [] (suc i) n ()
sublength (x ∷ l) (suc i) zero prf = refl
sublength (x ∷ l) (suc i) (suc n) prf = sublength l i (suc n) (nf` (i + suc n)  (length l) prf)

lengthhom : {X : Set} → (xs ys : List X) → length (xs +++ ys) ≡ length xs + length ys
lengthhom [] ys = refl
lengthhom (x ∷ xs) ys = cong suc (lengthhom xs ys)

convlem : ∀ N l s i n → (i + n ≤ length l) → s ◂ N → ((sub l i n) ≡ s) → l [ i , (i + n) [◂ N
convlem .Λ-NT l .[] i j p2 (empt' x) prf rewrite +-comm i j with nf j i (length l) p2
... | o rewrite sym (droplemm2 i l) with takelemm2 j (drop i l)  o 
... | q rewrite prf  | (sym q) = empt {_} {i} x (<≤ i (length l) p2)


convlem N l .(t ∷ []) i j  p2 (sngl' {.N} {t} x) prf rewrite +-comm i j with nf j i (length l) p2
... | o rewrite sym (droplemm2 i l) with takelemm2 j (drop i l)  o 
... | q rewrite prf  | (sym q) = sngl {_} {i} {N} x (subsub i t l prf) 


convlem N l .(s₁ +++ s₂) i j  p2 (cons' {.N} {B} {C} {s₁} {s₂} x pt pt₁) prf with takelemm s₁ s₂ | droplemm s₁ s₂
... | prf1 | prf2  rewrite sym prf  with taketake (length s₁) j (drop i l) (k prf) | q
  where
    k : take j (drop i l) ≡ s₁ +++ s₂ →  length s₁ ≤ j
    k prf' with sublength l i j  p2  
    k prf' | o  rewrite prf' | lengthhom s₁ s₂ = subst (λ h → foldr (λ _ → suc) 0 s₁ ≤ h) o (mio (length s₁) (length s₂)) 

    q :  length s₁ + length s₂ ≡ j
    q  with sublength l i j  p2 
    ... | o = subst (λ h → length s₁ + length s₂ ≡ h) o (subst (λ h → (length s₁ + length s₂) ≡ (length h)) (sym prf) (sym (lengthhom s₁ s₂))) 

... | z | w  rewrite z with droptakedrop (length s₁) i (length s₂) l  
... | u rewrite sym w | u | +-comm (length s₁) i = cons x (convlem B l s₁ i (length s₁) sm pt prf1) kl 
  where

   sm : i + length s₁ ≤ length l
   sm = nf``` (i + length s₁) (length s₂) (length l) (subst (λ h → h ≤ length l) (sym (+-assoc i (length s₁) (length s₂))) p2)
-- 
   kl : l [ i + length s₁ ,
      i + (foldr (λ _ → suc) 0 s₁ + foldr (λ _ → suc) 0 s₂) [◂ C
   kl rewrite sym (+-assoc i (length s₁) (length s₂)) = convlem C l s₂ (i + length s₁) (length s₂) (subst (λ h -> h ≤ length l) (sym (+-assoc i (length s₁) (length s₂))) p2) pt₁ prf2  


subsum : ∀ l i n m →  (sub l i n) +++ (sub l (i + n) m) ≡ sub l i (n + m)
subsum [] zero zero m = refl
subsum [] zero (suc n) zero = refl
subsum [] zero (suc n) (suc m) = refl
subsum (x ∷ l) zero zero m = refl
subsum (x ∷ l) zero (suc n) m with subsum l zero n m 
... | o = cong (_∷_ x) o
subsum [] (suc i) zero zero = refl
subsum [] (suc i) zero (suc m) = refl
subsum [] (suc i) (suc n) zero = refl
subsum [] (suc i) (suc n) (suc m) = refl
subsum (x ∷ l) (suc i) n m = subsum l i n m  


jjn : ∀ j n → j ≡ j + n → n ≡ 0
jjn zero n prf = sym prf
jjn (suc j) n prf =  (jjn j n (cong pred prf) )

iin : ∀ i n → suc i ≡ i + n → n ≡ 1
iin zero n prf = sym prf
iin (suc i) n prf = iin i n (cong pred prf)

≤+ : ∀ a b c → b + a ≤ c → a ≤ c
≤+ a b c p rewrite +-comm b a =  nf``` a b c p

f : ∀ i n n₁ m →  i + n ≡ suc (m + suc (n₁ + i)) → n ≡ suc n₁ + suc m
f i n n₁ m prf rewrite +-comm (suc n₁) i | +-comm (suc m) (i + suc n₁) | +-assoc i (suc n₁) (suc m) = f' i n (suc n₁ + suc m) prf 
  where
    f' : ∀ a b c → a + b ≡ a + c → b ≡ c
    f' zero b c prf = prf
    f' (suc a) b c prf = f' a b c (cong pred prf)


lemconv : ∀ N l j i n → l [ i , j [◂ N → j ≡ i + n → (sub l i n) ◂ N
lemconv .Λ-NT l j .j n (empt x p) natpr rewrite jjn j n natpr = empt'  x
lemconv N l .(suc i) i n (sngl x x₁) natpr rewrite iin i n natpr | subsub' i _ l x₁ = sngl'  x

lemconv N l .(i + n) i n (cons .{i} {k}  x tree tree₁) refl  with i ≟ k 
lemconv N l .(i + n) i n (cons x tree tree₁) refl | yes p  rewrite p | cyktree-lem1 tree = ex-falso-quodlibet (Λ-NT-Rule1 x) -- contradiction by axiom
lemconv N l .(i + n) i n (cons .{i} {k} x tree tree₁) refl | no ¬p with k ≟ (i + n)
lemconv N l .(i + n) i n (cons x tree tree₁) refl | no ¬p | yes p rewrite p | cyktree-lem1 tree₁ = ex-falso-quodlibet (Λ-NT-Rule2 x) --contradiction 
lemconv N l .(i + n) i n (cons x tree tree₁) refl | no ¬p₁ | no ¬p with cyktree-lem2 ¬p₁ tree | cyktree-lem2 ¬p tree₁
... | (n₁ , n₁prf ) | (m , mprf) rewrite n₁prf | mprf with lemconv _ l (suc n₁ + i) i (suc n₁) tree (trans (+-comm (suc n₁) i) refl) | lemconv _ l (suc m + suc (n₁ + i)) (suc (n₁ + i))  (suc m)  tree₁ (trans (+-comm (suc m) (suc n₁ + i)) refl)
... | tree1 | tree2 with cons' x tree1 tree2 
... | restree with subsum  l  i  (suc n₁) (suc m)
... | subprf rewrite +-comm i (suc n₁) | subprf  | f i n n₁ m mprf = restree
