

open import Utils.Logic

import CYK.GrammarCNF as CYKG

module CYK.Power (N : Set)(T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T)
  (G : CYKG.GrammarCNF N T _=n_ _=t_) where

open CYKG N T _=n_ _=t_
open GrammarCNF G

open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect)
open import Relation.Nullary

open import Data.Nat hiding (_<_;  _*_) 
open import Data.List renaming (_++_ to _+++_)
open import Data.Bool hiding (_≟_ ; T)
open import Data.Product hiding (map)

open import Utils.ArithmeticProperties
open import Utils.ListProperties
open import Utils.ListMonad

open import CYK.ParseTree N T _=n_ _=t_ G
open import CYK.TriplesStruct


-- COO matrix representation
MtrxEl : List T → Set
MtrxEl s = Σ[ i ∈ ℕ ] Σ[ j ∈ ℕ ] Σ[ B ∈ N ] s [ i , j [◂ B 


Mtrx : List T → Set
Mtrx s = List (MtrxEl s)


-- matrix multiplication
_**_ : ∀ {i k l m s B C} → s [ i , k [◂ B → s [ l , m [◂ C → Mtrx s
_**_ {i} {k} {l} {m} {s} {B} {C} t1 t2 with k ≟ l 
_**_  {i} {k} .{k} {m} {s} {B} {C} t1 t2 | yes refl 
  = (rhs-rules B C Rs)          >>= λ { (rhs , prf) → 
    [ _ , _ ,  _ , cons prf t1 t2 ] }
... | no p = [] 


_*_ : ∀ {s} → Mtrx s → Mtrx s → Mtrx s
_*_ {s} xs ys = xs     >>= λ { (_ , _ , _ , t₁) → 
                    ys     >>= λ { (_ , _ , _ , t₂) → 
                    t₁ ** t₂ }}


m-empty : (s : List T) → Nullable? ≡ true → Mtrx s 
m-empty s nullprf = desc-ls-< (suc (length s)) >>=  (λ { (x , prf) → [ x , x , Λ-NT , empt nullprf prf ] })


-- non-memoized version of powering (parametrized start)
pow-par : ∀ {s} → Mtrx s → (n : ℕ) → Acc n 
  → List (Σ[ i ∈ ℕ ] Σ[ j ∈ ℕ ] (suc i) + (suc j) ≡ n)
  → Mtrx s
pow-par m zero accn trpls with inspect Nullable? 
pow-par {s} m zero accn trpls | it true prf = m-empty s prf --[ 0 , _ , _ , empt prf {!!} ]
pow-par m zero accn trpls | it false prf = []
pow-par m (suc zero) accn trpls  = m
pow-par m (suc n) (acc acf) trpls = trpls   >>=  λ { (l₁ , l₂ , l₃) →  
  (pow-par m (suc l₁) (acf (suc l₁) (<-lemm3 {l₁} l₃)) (triples l₁) )  *
  (pow-par m (suc l₂) (acf (suc l₂) (<-lemm2 {l₁}  l₃))  (triples l₂)) }


pow : ∀ {s} → Mtrx s → (n : ℕ) → Acc n → Mtrx s
pow m zero accn with inspect Nullable? 
pow {s} m zero accn | it true prf = m-empty s prf
pow m zero accn | it false prf = []
pow m (suc n) accn = pow-par m (suc n) accn (triples n)


-- matrix initialization
m-init : (s : List T) → Mtrx s
m-init s =     [0… (length s)]                   >>=  λ pos   → 
                 (subs pos s)                      >>=  λ { (t , sub)  → 
                 (sngl-rhs-rules  t Rs)             >>=  λ { (rhs , prf)   → 
                 [ _ , _ , _ , sngl prf sub ] }}
