

module CYK.README where

-- Definition of context-free grammar in Chomsky normal form
open import CYK.GrammarCNF

-- Definition of inductive parse tree datatype for GrammarCNF. 
-- Specifically tuned for CYK parsing algorithm
open import CYK.ParseTree

-- Simplflified definition of parse trees for GrammarCNF.
-- Conversions between parse trees.
open import CYK.ParseTreeWrapper

-- generating the "convoluting" set of naturals 
-- triples n = { (a , b , prf) | prf : suc a + suc b = suc n  }
open import CYK.TriplesStruct

-- Definition of CYK matrices.
-- Matrix multiplication.
-- Computing the CYK table by using the TriplesStruct (non-memoized).
open import CYK.Power

-- The CYK table computed in CYK.Power is complete
open import CYK.Completeness

-- Definition of certified memoization tables.
-- Memoized version of CYK table computation.
-- Proof of completeness.
open import CYK.MemPower
