

module CYK.TriplesStruct where

open import Relation.Binary.PropositionalEquality hiding ([_])

open import Data.Nat hiding (_<_)
open import Data.List renaming (_++_ to _+++_)
open import Data.Product hiding (map)

open import Function

open import Utils.ListMonad
open import Utils.ArithmeticProperties
open import Utils.ListProperties

-- type synonyms
Triple  : (n : ℕ) → Set
Triple n = (Σ[ i ∈ ℕ ] Σ[ j ∈ ℕ ] (suc i) + (suc j) ≡ n)

Triples  : (n : ℕ) → Set
Triples n = List (Triple n)

projTI = proj₁

projTJ : ∀ {n} → Triple n → ℕ
projTJ = proj₁ ∘ proj₂

projTP : ∀ {n} → (t : Triple (suc n)) → (suc (projTI t)) + (suc (projTJ t)) ≡ (suc n)
projTP = proj₂ ∘ proj₂


-- desceding list of ℕ
desc-ls : ℕ → List ℕ
desc-ls zero = []
desc-ls (suc n) = n ∷ desc-ls n


-- ascending list of ℕ
asc-ls : ℕ → ℕ → List ℕ
asc-ls n zero = []
asc-ls n (suc n') = n ∷ asc-ls (suc n) n'


-- asceding list of ℕ starting from 0
[0…_] : ℕ → List ℕ
[0… n ] = asc-ls 0 n


-- asceding list length
asc-ls-len : ∀ i n → length (asc-ls i n) ≡ n
asc-ls-len i zero = refl
asc-ls-len i (suc n) = cong suc (asc-ls-len (suc i) n)


-- desceding list with the proof that it contains elements smaller than argument `n`
desc-ls-< : (n :  ℕ) →  List (Σ[ x ∈ ℕ ] x < n) 
desc-ls-< zero    = []
desc-ls-< (suc n) = (n , <-base) ∷  map  (λ { (p₁ , p₂) → (p₁ , <-step p₂) })  (desc-ls-< n) 


-- proofs
desc-ls-el : (k n : ℕ) → k < n → el k 0 (desc-ls n) ≡ n ∸ (suc k)
desc-ls-el zero .1 <-base = refl
desc-ls-el (suc n) .(suc (suc n)) <-base = desc-ls-el n (suc n) <-base
desc-ls-el zero .(suc n) (<-step {n} y) = refl
desc-ls-el (suc n) .(suc n') (<-step {n'} y) = desc-ls-el n n' (<-weak n n' y)


desc-ls-el-cor : (k n : ℕ) → k < n → el (n ∸ (suc k)) 0 (desc-ls n) ≡ k
desc-ls-el-cor k .(suc k) <-base rewrite k∸k≡0 k = refl
desc-ls-el-cor zero .1 (<-step {zero} y) = refl
desc-ls-el-cor zero .(suc (suc n)) (<-step {suc n} y) = desc-ls-el-cor zero (suc n) y
desc-ls-el-cor (suc n) .(suc n') (<-step {n'} y) 
 = trans (desc-ls-el  ((n' ∸ suc n)) (suc n') (∸-lemm4 n' (suc n))) (∸-lemm3 y)


asc-ls-el : (k n i : ℕ) → k < n → el k 0 (asc-ls i n) ≡ (i + k)
asc-ls-el zero .1 i <-base = sym (+-comm i 0)
asc-ls-el (suc n) .(suc (suc n)) i <-base rewrite asc-ls-el n (suc n) (suc i) <-base = sym (arth-lem1 i n)
asc-ls-el zero .(suc n) i (<-step {n} y) = sym (+-comm i 0)
asc-ls-el (suc n) .(suc n') i (<-step {n'} y) rewrite asc-ls-el n n' (suc i) (<-weak _ _ y) = sym (arth-lem1 i n)


desc-ls-<-comp : (j n : ℕ) → (p : j < (suc n)) → (j , p) ∈ (desc-ls-< (suc n))
desc-ls-<-comp .0 zero <-base = here
desc-ls-<-comp .(suc n) (suc n) <-base = here
desc-ls-<-comp j zero (<-step ())
desc-ls-<-comp j (suc n) (<-step y) 
 = there (∃-after-map (j , y) _ (λ {(p₁ , p₂) →  (p₁ , <-step p₂)}) (desc-ls-<-comp j n y))


desc-ls-<-comp' : (j n : ℕ) → (p : j < n) → (j , p) ∈ (desc-ls-< n)
desc-ls-<-comp' j zero ()
desc-ls-<-comp' j (suc n) p = desc-ls-<-comp j n p


pairs-sound-lem1 : (k n i : ℕ) → k < n → suc (el k 0 (desc-ls n) + el k 0 (asc-ls i n)) ≡ (i + n)
pairs-sound-lem1 zero .1 i <-base rewrite +-comm i 1 = refl
pairs-sound-lem1 (suc n) .(suc (suc n)) i <-base 
  = trans (pairs-sound-lem1 n (suc n) (suc i) <-base) (sym (arth-lem1 i (suc n)))
pairs-sound-lem1 zero .(suc n) i (<-step {n} y) 
  = trans (cong suc (+-comm n i)) (sym (arth-lem1 i n))
pairs-sound-lem1 (suc n) .(suc n') i (<-step {n'} y) 
  =  trans (pairs-sound-lem1 n n' (suc i) (<-weak n n' y)) (sym (arth-lem1 i n'))


triples-f : (n : ℕ) → (Σ[ x ∈ ℕ ]  x < n) → Triples (suc n)
triples-f n (k , k<n) 
 = [ el k 0 (desc-ls n) , 
    el k 0 (asc-ls 0 n) , cong suc (trans (arth-lem1 (el k 0 (desc-ls n)) (el k 0 (asc-ls 0 n))) (pairs-sound-lem1 _ _ 0 k<n)) ]


triples : (n : ℕ) →  Triples (suc n)
triples n = desc-ls-< n >>= triples-f n


triples-complete-lem1 : ∀ {i j l m n} → (i ≡ l) → (j ≡ m) 
  → (p : (suc i + suc j) ≡ suc n) 
  → (q : (suc l + suc m) ≡ suc n)
  → (i , j , p) ∈ [ (l , m , q) ]
triples-complete-lem1 .{l} .{m} {l} {m} .{(l + suc m)} refl refl refl refl = here


-- triples is complete
triples-complete : ∀ i j n
 → (p : (suc i) + (suc j) ≡ (suc n)) 
 → (i , j , p) ∈ triples n
triples-complete i j n p 
  with list-monad-ht (i , j , p) (desc-ls-< n) (triples-f n) 
         (j , <-cong2 (<-lemm2 {i} p)) 
         (desc-ls-<-comp' j n (<-cong2 (<-lemm2 {i} p)))
triples-complete i j n p | v 
  with desc-ls-el j n (<-cong2 (<-lemm2 {i} p)) 
  | asc-ls-el j n 0 (<-cong2 (<-lemm2 {i} p))
... | q | w rewrite sym (∸-lemm7 j i n (+-comm-sum {suc i} p))  
  = v (triples-complete-lem1 (sym q) (sym w) p (cong suc
        (trans (arth-lem1 (el {ℕ} j 0 (desc-ls n)) (el {ℕ} j 0 (asc-ls 0 n)))
         (pairs-sound-lem1 j n 0 (<-cong2 (<-lemm2 {i} p))))))
