

module GeneralParsing.Examples.ParseTree where

open import Data.Char
open import Data.List
open import Data.Product

open import Fin.FiniteSubset

open import GeneralParsing.GrammarFin Char Char _≟_ _≟_
open import GeneralParsing.GrammarFinTree Char Char _≟_ _≟_

open import CNF.Grammar  Char Char _≟_ _≟_ hiding (_≟_)

open import Utils.Logic
open import Utils.ListProperties



rule1 rule2 rule3 rule4 : Rule
rule1 = 'A' ⟶ (nt 'B' ∷ nt 'A' ∷ []) 
rule2 = 'B' ⟶ [ tm '0' ] 
rule3 = 'B' ⟶ [ tm '1' ] 
rule4 = 'A' ⟶ [ nt 'B' ] 

MyGrammar : GrammarFin
MyGrammar = record {
   SF = 'A' ;
   Rule-Desc = fs-plain (rule1 ∷ rule2 ∷ rule3 ∷ rule4 ∷ [])
 }


tree : TreeFinS MyGrammar ('0' ∷ '1' ∷ '0' ∷ [])
tree = 
 node (rule1 , _ )
          (node ⟦ rule2 ⟧ ('0' ∷t ⟦⟧) ∷n 
          (node ⟦ rule1 ⟧ (node ⟦ rule3 ⟧ ('1' ∷t ⟦⟧) ∷n 
                      (node ⟦ rule4 ⟧ (node ⟦ rule2 ⟧ ('0' ∷t ⟦⟧) ∷n ⟦⟧) ∷n ⟦⟧)) ∷n ⟦⟧))



-- The constructed tree is well-typed under modifications of original grammar
-- as long as all the rules are present
MyGrammar' : GrammarFin
MyGrammar' = record {
   SF = 'A' ;
   Rule-Desc = fs-plain (rule4 ∷ rule3 ∷ rule2 ∷ rule1 ∷ 'A' ⟶ [ nt 'A' ] ∷  [])
 }

tree' : TreeFinS MyGrammar'  ('0' ∷ '1' ∷ '0' ∷ [])
tree' =  node (rule1 , _ )
          (node ⟦ rule2 ⟧ ('0' ∷t ⟦⟧) ∷n 
          (node ⟦ rule1 ⟧ (node ⟦ rule3 ⟧ ('1' ∷t ⟦⟧) ∷n 
                      (node ⟦ rule4 ⟧ (node ⟦ rule2 ⟧ ('0' ∷t ⟦⟧) ∷n ⟦⟧) ∷n ⟦⟧)) ∷n ⟦⟧))
