
module GeneralParsing.Examples.Parsing2 where

open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect)

open import Data.Nat
open import Data.Nat.Show 
open import Data.Sum
open import Data.Product
open import Data.List hiding ([_])
open import Data.Char renaming (_≟_ to _=C?_)
open import Data.String renaming (_++_ to _++s_) hiding (_≟_)
open import Data.Colist renaming (take to takec) hiding (length ; [_] ; _∈_)
open import Data.BoundedVec.Inefficient renaming (toList to toListb)

open import Function

open import Foreign.Haskell
open import IO.Primitive

open import CNF.NormStringInstance
open import CNF.Grammar StringC Char _=S?_ _=C?_ renaming (_≟_ to _=Rule?_)
open import CNF.ParseTree StringC Char _=S?_ _=C?_

open import Fin.FiniteSubset

open import GeneralParsing.GrammarFin StringC Char _=S?_ _=C?_
open import GeneralParsing.GrammarFinTree StringC Char _=S?_ _=C?_ 
open import GeneralParsing.GrammarFinTreePrinter
open import GeneralParsing.FinParsing StringC Char _=S?_ _=C?_  newntlst newntlstlem
open import CNF.NormGrammar StringC Char _=S?_ _=C?_  newntlst newntlstlem
open import GeneralParsing.GrammarFin2GrammarGen StringC Char _=S?_ _=C?_ 

open import Utils.Logic
open import Utils.ListMembership

rulesgen : Rules
rulesgen =   ′ "E" ′ ⟶  (nt ′ "T" ′ ∷ nt ′ "P" ′  ∷ nt ′ "E" ′ ∷ [])
           ∷ ′ "E" ′ ⟶  (nt ′ "T" ′ ∷ [])

           ∷ ′ "T" ′ ⟶ (nt ′ "F" ′ ∷  nt ′ "M" ′ ∷  nt ′ "T" ′ ∷ [])
           ∷ ′ "T" ′ ⟶ (nt ′ "F" ′ ∷ [])

           ∷ ′ "F" ′ ⟶ (tm '0' ∷ [])
           ∷ ′ "F" ′ ⟶ (tm '1' ∷ [])

           ∷ ′ "P" ′ ⟶ (tm '+' ∷ [])
           ∷ ′ "M" ′ ⟶ (tm '*' ∷ [])


           ∷ []

rules : Rules
rules = rulesgen

G : GrammarFin
G = ⟪  ′ "E"  ′ ,  fs-plain rules ⟫



main : IO Unit
main = putStrLn (toCostring (Data.String.fromList (gftostr NG')))
  where
    G' = Fin2Gen G
    NG' = normS G'

-- compile it with C-c C-x C-c
main' : IO Unit
main' = getContents >>= 
                   putStrLn 
                 ∘ toCostring 

--                 ∘ Data.Nat.Show.show 
--                 ∘ length 

                 ∘ Data.String.fromList
                 ∘ Data.List.concat
                 ∘ Data.List.map tostr

                 ∘ finparsesq G
                 ∘ getLine
                 ∘ toListb 
                 ∘ takec 100
  where
    getLine : List Char → List Char
    getLine ('\n' ∷ xs) = []
    getLine (x ∷ xs) = x ∷ getLine xs
    getLine [] = []

