

module GeneralParsing.Examples.Testing where

open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect)


open import Data.Nat
open import Data.Sum

open import Data.Product
open import Data.List hiding ([_])
open import Data.Nat.Show 
open import Data.Char renaming (_≟_ to _=C?_)
open import Data.String renaming (_++_ to _++s_) hiding (_≟_)
open import Data.Colist renaming (take to takec) hiding (length ; [_] ; _∈_)
open import Data.BoundedVec.Inefficient renaming (toList to toListb)

open import Function


open import Foreign.Haskell
open import IO.Primitive

open import CNF.NormStringInstance
open import CNF.Grammar StringC Char _=S?_ _=C?_ renaming (_≟_ to _=Rule?_)
open import CNF.ParseTree StringC Char _=S?_ _=C?_

open import Utils.ListMembership

{-
rulesgen : Rules
rulesgen =   ′ "Expr" ′ ⟶  (tm '1' ∷ []) --∷ []
           ∷ ′ "Expr" ′ ⟶  (nt ′ "Term" ′ ∷ [])
           ∷ ′ "Expr" ′ ⟶ (nt ′ "Expr" ′ ∷  nt ′ "AddOp" ′ ∷  (nt ′ "Term" ′ ) ∷ [])
           ∷ ′ "Expr" ′ ⟶ (nt ′ "AddOp" ′ ∷ nt ′ "Term" ′ ∷ [])



           ∷ ′ "Term" ′ ⟶ (nt ′ "Factor" ′ ∷ []) 
           ∷ ′ "Term" ′ ⟶ (nt ′ "Term" ′ ∷ nt ′ "MulOp" ′ ∷ nt ′ "Factor" ′ ∷ []) 

           ∷ ′ "Factor" ′ ⟶ (nt ′ "Primary" ′ ∷ []) 
           ∷ ′ "Factor" ′ ⟶ (nt ′ "Factor" ′ ∷ tm '^' ∷ nt ′ "Primary" ′ ∷ [])

           ∷ ′ "Primary" ′ ⟶ (nt ′ "Number" ′ ∷ [])
           ∷ ′ "Primary" ′ ⟶ (tm '(' ∷ nt ′ "Expr" ′ ∷ tm ')' ∷ [])

           ∷ ′ "AddOp" ′ ⟶ (tm '+' ∷ [])
           ∷ ′ "AddOp" ′ ⟶ (tm '-' ∷ [])

           ∷ ′ "MulOp" ′ ⟶ (tm '*' ∷ [])
           ∷ ′ "Expr" ′ ⟶  (tm '1' ∷ [])
           ∷ ′ "MulOp" ′ ⟶ (tm '/' ∷ [])

           ∷ ′ "Number" ′ ⟶ (tm '0' ∷ [])
           ∷ ′ "Number" ′ ⟶ (tm '1' ∷ [])

           ∷ []

rulesgen' : Rules
rulesgen' =  
              
           ′ "Expr" ′ ⟶  (nt ′ "Term" ′ ∷ [])
           ∷ ′ "Expr" ′ ⟶ (nt ′ "Expr" ′ ∷  nt ′ "AddOp" ′ ∷  (nt ′ "Term" ′ ) ∷ [])
            ∷ ′ "Expr" ′ ⟶ (nt ′ "AddOp" ′ ∷ nt ′ "Term" ′ ∷ [])



           ∷ ′ "Term" ′ ⟶ (nt ′ "Factor" ′ ∷ []) 
           ∷  ′ "Term" ′ ⟶ (nt ′ "Term" ′ ∷ nt ′ "MulOp" ′ ∷ nt ′ "Factor" ′ ∷ []) 

           ∷ ′ "Factor" ′ ⟶ (nt ′ "Primary" ′ ∷ []) 
           ∷ ′ "Factor" ′ ⟶ (nt ′ "Factor" ′ ∷ tm '^' ∷ nt ′ "Primary" ′ ∷ [])

            ∷ ′ "Primary" ′ ⟶ (nt ′ "Number" ′ ∷ [])
           ∷   ′ "Primary" ′ ⟶ (tm '(' ∷ nt ′ "Expr" ′ ∷ tm ')' ∷ [])

           ∷ ′ "AddOp" ′ ⟶ (tm '+' ∷ [])
           ∷ ′ "AddOp" ′ ⟶ (tm '-' ∷ [])

           ∷ ′ "MulOp" ′ ⟶ (tm '*' ∷ [])
           ∷ ′ "MulOp" ′ ⟶ (tm '/' ∷ [])

           ∷ ′ "Number" ′ ⟶ (tm '0' ∷ [])
           ∷ ′ "Number" ′ ⟶ (tm '1' ∷ [])
           ∷ ′ "S" ′ ⟶  (nt ′ "Expr" ′ ∷ [])

           ∷ []



open import CNF.NormCorrectness  StringC Char _=S?_ _=C?_ newntlst newntlstlem
open import CNF.NormGrammar  StringC Char _=S?_ _=C?_ newntlst newntlstlem
open import GeneralParsing.GrammarGen2GrammarCNF StringC Char _=S?_ _=C?_
open import CYK.ParseTree StringC Char _=S?_ _=C?_  renaming (_[_,_[◂_ to TreeCNF)
open import CYK.GrammarCNF StringC Char _=S?_ _=C?_ renaming (Rules to RulesCNF ; Rule to RuleCNF)
open GrammarCNF renaming (Rs to RsCNF)
open import CYK.MemPower StringC Char _=S?_ _=C?_
open import GeneralParsing.TreeGen2TreeCNF StringC Char _=S?_ _=C?_


genparse''' : (G : Grammar) → well-formed G → (S G) ∉ RHS (Rs G) → (s : StringC) → List (TreeS (⟨ (S G) , norm (Rs G) ⟩)  s)
genparse''' ⟨ S , rules ⟩  wf nin s = ltgen'
  where
    rules' = norm rules -- normalized G
    cnf = norm-progress rules
    G = ⟨ S , rules ⟩
    G' = ⟨ S , rules' ⟩
 
    iscnfg' = (λ a rhs ri → inj₁ (cnf a rhs ri) , rhslem S  rules wf nin)

    GCNF = (Gen2CNF G')  iscnfg'


    ltcnf : List (TreeCNF GCNF s 0 (length s) (Λ-NT GCNF))
    ltcnf = simple-parsing-start GCNF s


    ltgen' : List (TreeS G' s)
    ltgen' = Data.List.map (tt2' G' iscnfg' {Λ-NT GCNF} {s}) ltcnf


genparse'' : (G : Grammar) → well-formed G → (S G) ∉ RHS (Rs G) → (s : StringC) → List (TreeS G s)
genparse'' ⟨ S , rules ⟩  wf nin s = ltgen
  where
    rules' = norm rules -- normalized G
    cnf = norm-progress rules
    G = ⟨ S , rules ⟩
    G' = ⟨ S , rules' ⟩
 
    iscnfg' = (λ a rhs ri → inj₁ (cnf a rhs ri) , rhslem S  rules wf nin)

    GCNF = (Gen2CNF G')  iscnfg'


    ltcnf : List (TreeCNF GCNF s 0 (length s) (Λ-NT GCNF))
    ltcnf = simple-parsing-start GCNF s


    ltgen' : List (TreeS G' s)
    ltgen' = Data.List.map (tt2' G' iscnfg' {Λ-NT GCNF} {s}) ltcnf

    ltgen : List (TreeS G  s)
    ltgen = Data.List.map (λ t → norm-snd _ _ _ t wf) ltgen'


module ExFinParsing where

  open import Fin.FiniteSubset
  open import GeneralParsing.GrammarFin StringC Char _=S?_ _=C?_
  open import GeneralParsing.GenParsing StringC Char _=S?_ _=C?_ newntlst newntlstlem
  open import CNF.ParseTreePrinter


  GF : Grammar
  GF = ⟨ ′ "S" ′ , rulesgen' ⟩


  postulate hh : well-formed GF
  postulate h : ′ "S" ′ ∉ RHS rulesgen'
  
  main' : IO Unit
  main' = getContents >>= 
                     putStrLn 
                   ∘ toCostring 

--                   ∘ Data.Nat.Show.show 
--                   ∘ length 

                   ∘ Data.String.fromList
                   ∘ Data.List.concat
                   ∘ Data.List.map tostr

                   ∘ genparse'' GF hh h
                   ∘ getLine
                   ∘ toListb 
                   ∘ takec 500
    where
      getLine : List Char → List Char
      getLine ('\n' ∷ xs) = []
      getLine (x ∷ xs) = x ∷ getLine xs
      getLine [] = []

open ExFinParsing
main = main'

  
{-


module ExFin where

  open import Fin.FiniteSubset

  open import GeneralParsing.GrammarFin StringC Char _=S?_ _=C?_
  open import GeneralParsing.GrammarFinTree StringC Char _=S?_ _=C?_ 
  open import GeneralParsing.GrammarFinTreePrinter
  open import GeneralParsing.FinParsing StringC Char _=S?_ _=C?_  newntlst newntlstlem

  open import Utils.Logic

  rules : Rules
  rules = rulesgen

  G : GrammarFin
  G = ⟪  ′ "Expr"  ′ ,  fs-plain rules ⟫



  main' : IO Unit
  main' = getContents >>= 
                     putStrLn 
                   ∘ toCostring 

  --                 ∘ Data.Nat.Show.show 
  --                 ∘ length 

                   ∘ Data.String.fromList
                   ∘ Data.List.concat
                   ∘ Data.List.map tostr

                   ∘ finparsesq G
                   ∘ getLine
                   ∘ toListb 
                   ∘ takec 100
    where
      getLine : List Char → List Char
      getLine ('\n' ∷ xs) = []
      getLine (x ∷ xs) = x ∷ getLine xs
      getLine [] = []

-}

{-
module ExGen where

  open import CNF.NormCorrectness StringC Char _=S?_ _=C?_  newntlst newntlstlem
  open import CNF.ParseTreePrinter


  rules : Rules
  rules = rulesgen'

  rulesN : Rules
  rulesN = norm rules

  postulate i1 : (′ "Expr" ′ , inj₂ '1' ∷ []) ∈ rulesN

  tree : Tree rulesN ′ "Expr" ′ ′ "1" ′
  tree = node i1  ('1' ∷t ⟦⟧) 


  t : Tree rules ′ "Expr" ′ ′ "1" ′
  t = norm-snd _ _ _ tree here

  main' : IO Unit
  main' = putStrLn $ toCostring $ Data.String.fromList $ tostr t
-}

{-
module ExUnit where

  open import CNF.ParseTreePrinter
  open import CNF.NormUnitRules StringC Char _=S?_ _=C?_ 
  open import CNF.NormEpsRules StringC Char _=S?_ _=C?_ 

  rules : Rules
  rules = rulesgen'

  rulesN : Rules
  rulesN = norm-u rules

  postulate h1 : (′ "Expr" ′ , inj₂ '1' ∷ []) ∈ rulesN
  postulate h2 : (′ "Term" ′ , inj₂ '1' ∷ []) ∈ rulesN
  postulate h3 : (′ "AddOp" ′ , inj₂ '+' ∷ []) ∈ rulesN
  postulate h4 : (′ "Expr" ′ , (nt ′ "Expr" ′ ∷  nt ′ "AddOp" ′ ∷  (nt ′ "Term" ′ ) ∷ [])) ∈ rulesN
  --  h =  here


  tree : Tree rulesN ′ "Expr" ′ ′ "1" ′
  tree = node h1  ('1' ∷t ⟦⟧) 

  tree1 : Tree rulesN ′ "Expr" ′ ′ "1+1" ′
  tree1 =   node h4 (node h1 ('1' ∷t ⟦⟧) ∷n (node h3 ('+' ∷t ⟦⟧) ∷n (node h2 ('1' ∷t ⟦⟧) ∷n ⟦⟧))) -- node h

  tree2 : Tree rulesN ′ "Expr" ′ ′ "1+1+1" ′
  tree2 =  node h4 (tree1 ∷n (node h3 ('+' ∷t ⟦⟧) ∷n (node h2  ('1' ∷t ⟦⟧) ∷n ⟦⟧)))


  t2 : Tree rules ′ "Expr" ′ ′ "1+1+1" ′
  t2 = (nu-snd _ _ _ tree2)

  t1 : Tree rules ′ "Expr" ′ ′ "1+1" ′
  t1 = (nu-snd _ _ _ tree1)

  t : Tree rules ′ "Expr" ′ ′ "1" ′
  t = nu-snd _ _ _ tree

  main' : IO Unit
  main' = putStrLn $ toCostring $ Data.String.fromList $ tostr t2

open ExUnit

main = main'
-}


{-
module ExEps where

  open import CNF.ParseTreePrinter
  open import CNF.NormEpsRules StringC Char _=S?_ _=C?_
  open import CNF.Nullable StringC Char _=S?_ _=C?_

  rules : Rules
  rules = rulesgen

  nlblz = nullables rulesgen

  rulesN : Rules
  rulesN = norm-e rules

  postulate h1 : (′ "Expr" ′ , inj₂ '1' ∷ []) ∈ rulesN
  postulate h2 : ′ "Expr" ′ ⟶ (nt ′ "Expr" ′ ∷  nt ′ "AddOp" ′ ∷  (nt ′ "Term" ′ ) ∷ []) ∈ rulesN
  postulate h3 : (′ "AddOp" ′ , inj₂ '+' ∷ []) ∈ rulesN
  postulate h4 : ′ "Term" ′ ⟶ (nt ′ "Factor" ′  ∷ []) ∈ rulesN
  postulate h5 : ′ "Factor" ′ ⟶ (nt ′ "Primary" ′  ∷ []) ∈ rulesN
  postulate h6 : ′ "Primary" ′ ⟶ (nt ′ "Number" ′  ∷ []) ∈ rulesN
  postulate h7 : ′ "Number" ′ ⟶ (tm '1'  ∷ []) ∈ rulesN


  tree : Tree rulesN ′ "Term" ′ ′ "1" ′
  tree = node h4 (node h5 (node h6 (node h7 ('1' ∷t ⟦⟧) ∷n ⟦⟧) ∷n ⟦⟧) ∷n ⟦⟧)

  tree2 : Tree rulesN ′ "Expr" ′ ′ "1+1+1" ′
  tree2 = node h2 (node h2 (node h1 ('1' ∷t ⟦⟧) ∷n ((node h3 ('+' ∷t ⟦⟧) ∷n (tree ∷n ⟦⟧)))) ∷n (node h3 ('+' ∷t ⟦⟧) ∷n (tree ∷n ⟦⟧)))

--  open NormEpsSound rules

  t : Tree rules ′ "Expr" ′ ′ "1+1+1" ′
  t = ne-snd _ _ _ tree2

  main' : IO Unit
  main' = putStrLn $ toCostring $ Data.String.fromList $ tostr t

open ExEps
main = main'
-}

{-
module ExLong where

  open import CNF.ParseTreePrinter
  open import CNF.NormLongRules StringC Char _=S?_ _=C?_ newntlst newntlstlem

  rules = rulesgen

  rulesN : Rules
  rulesN = norm-l rules

  tree : Tree rulesN ′ "Expr" ′ ′ "1" ′
  tree = node here  ('1' ∷t ⟦⟧) 

  postulate h  : (nt ′ "Expr" ′)  ∈ filterAllSmbls rulesN


  t = nl-snd rulesN _ _ (nl-measure rules) tree h

  main' : IO Unit
  main' = putStrLn $ toCostring $ Data.String.fromList $ tostr t

open ExLong
main = main'
-}

{-
module ExTerm where

  open import CNF.ParseTreePrinter
  open import CNF.NormTermRules StringC Char _=S?_ _=C?_ newntlst newntlstlem

  rules = rulesgen

  rulesN : Rules
  rulesN = norm-t rules


  postulate h1 : (′ "Expr" ′ , inj₂ '1' ∷ []) ∈ rulesN
  postulate h2 : ′ "Expr" ′ ⟶ (nt ′ "Expr" ′ ∷  nt ′ "AddOp" ′ ∷  (nt ′ "Term" ′ ) ∷ []) ∈ rulesN
  postulate h3 : (′ "AddOp" ′ , inj₂ '+' ∷ []) ∈ rulesN
  postulate h4 : ′ "Term" ′ ⟶ (nt ′ "Factor" ′  ∷ []) ∈ rulesN
  postulate h5 : ′ "Factor" ′ ⟶ (nt ′ "Primary" ′  ∷ []) ∈ rulesN
  postulate h6 : ′ "Primary" ′ ⟶ (nt ′ "Number" ′  ∷ []) ∈ rulesN
  postulate h7 : ′ "Number" ′ ⟶ (tm '1'  ∷ []) ∈ rulesN


  tree : Tree rulesN ′ "Term" ′ ′ "1" ′
  tree = node h4 (node h5 (node h6 (node h7 ('1' ∷t ⟦⟧) ∷n ⟦⟧) ∷n ⟦⟧) ∷n ⟦⟧)

  tree2 : Tree rulesN ′ "Expr" ′ ′ "1+1+1" ′
  tree2 = node h2 (node h2 (node h1 ('1' ∷t ⟦⟧) ∷n ((node h3 ('+' ∷t ⟦⟧) ∷n (tree ∷n ⟦⟧)))) ∷n (node h3 ('+' ∷t ⟦⟧) ∷n (tree ∷n ⟦⟧)))


  postulate h  : (nt ′ "Expr" ′)  ∈ filterAllSmbls rulesN


  t = nt-snd  rulesN _ _ tree2 h

  main' : IO Unit
  main' = putStrLn $ toCostring $ Data.String.fromList $ tostr t

open ExTerm
main = main'
-}
-}
