
open import Relation.Binary
open import Relation.Nullary
open import Relation.Binary.PropositionalEquality 
            hiding ([_]; inspect)
open import Data.List
open import Data.Product
open import Data.Sum
open import Data.Bool
open import Data.Nat
open import Utils.ListsAddition
open import Utils.ListProperties

module GeneralParsing.FinParsing
  (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T})) 
  (newntlst : List N → N)  
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns) where


open import CYK.ParseTree N T _=n_ _=t_  renaming (_[_,_[◂_ to TreeCNF)
open import CYK.ParseTreeWrapper N T _=n_ _=t_ 
open import CYK.GrammarCNF renaming (Rules to RulesCNF ; Rule to RuleCNF)
open import CYK.Power N T _=n_ _=t_ 
open import CYK.MemPower N T _=n_ _=t_ 

open import CNF.Grammar N T _=n_ _=t_ renaming (Rules to RulesGen ; Rule to RuleGen)
open import CNF.ParseTree N T _=n_ _=t_
open import CNF.NormGrammar N T _=n_ _=t_ newntlst newntlstlem

open import GeneralParsing.GrammarGen2GrammarCNF N T _=n_ _=t_ 
open import GeneralParsing.GrammarFin N T _=n_ _=t_ 
open import GeneralParsing.TreeGen2TreeCNF N T _=n_ _=t_ 
open import GeneralParsing.GrammarFin2GrammarGen N T _=n_ _=t_ 
open import GeneralParsing.GrammarFinTree N T _=n_ _=t_ 
open import GeneralParsing.TreeFin2TreeGen N T _=n_ _=t_ newntlst newntlstlem
open import GeneralParsing.GenParsing N T _=n_ _=t_ newntlst newntlstlem

open import Fin.FiniteSubset


finparse : (G : GrammarFin) → well-formed-fin G → (s : List T) → List (TreeFinS G s)
finparse ⟪ SF , fs-plain desc  ⟫ wf s  = Data.List.map (λ t → gen2fin t) ls
  where
    ls = genparse (Fin2Gen ⟪ SF , fs-plain desc  ⟫) wf s

finparse-complete : (G : GrammarFin) → (wf : well-formed-fin G) → (s : List T) → TreeFinS G s → Σ[ t ∈ TreeFinS G s ] t ∈ finparse G wf s
finparse-complete ⟪ SF , fs-plain xs ⟫ wf s tf = gen2fin (proj₁ t'') , ex1_comp' (proj₁ t'')  (genparse _ wf s) gen2fin (proj₂ t'')
  where
   G = ⟪ SF , fs-plain xs ⟫

   t' : TreeS (Fin2Gen G) s
   t' = fin2gen tf

   t'' : Σ[ t ∈ TreeS (Fin2Gen G) s ] t ∈ genparse _ wf s
   t'' = genparse-complete (Fin2Gen G) wf s  t'

open import Utils.Logic

finparsesq : (G : GrammarFin) → {d : ∥ well-formed-fin-dec G ∥ } → (s : List T) → List (TreeFinS G s)
finparsesq G {d} s = finparse G (∥-∥-yes _ {d}) s
