

open import Relation.Binary
open import Relation.Nullary
open import Relation.Binary.PropositionalEquality 
            hiding ([_]; inspect)
open import Data.List
open import Data.Product
open import Data.Sum
open import Data.Bool
open import Data.Nat
open import Utils.ListsAddition
open import Utils.ListProperties

module GeneralParsing.GenParsing
  (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T})) 
  (newntlst : List N → N)  
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns) where

open import CNF.Grammar N T _=n_ _=t_ renaming (Rules to RulesGen ; Rule to RuleGen)
open import CNF.ParseTree N T _=n_ _=t_ 
open import CNF.NormGrammar N T _=n_ _=t_ newntlst newntlstlem
open import CNF.NormCorrectness N T _=n_ _=t_ newntlst newntlstlem

open import CYK.ParseTree N T _=n_ _=t_  renaming (_[_,_[◂_ to TreeCNF)
open import CYK.ParseTreeWrapper N T _=n_ _=t_ 
open import CYK.GrammarCNF N T _=n_ _=t_ renaming (Rules to RulesCNF ; Rule to RuleCNF)
open import CYK.Power N T _=n_ _=t_ 
open import CYK.MemPower N T _=n_ _=t_ 

open import GeneralParsing.GrammarGen2GrammarCNF N T _=n_ _=t_ 
open import GeneralParsing.TreeGen2TreeCNF N T _=n_ _=t_ 

open GrammarCNF

genparse : (G : Grammar) → well-formed G → (s : List T) → List (TreeS G s)
genparse G wf s = ltgen
  where
    G' = normS G -- normalized G
    cnf = progress G wf -- G' is in cnf
    GCNF = Gen2CNF G' cnf

    ltcnf : List (TreeCNF GCNF s 0 (length s) (Λ-NT GCNF))
    ltcnf = simple-parsing-start GCNF s

    ltgen' : List (TreeS G' s)
    ltgen' = Data.List.map (tt2' G' cnf {Λ-NT GCNF} {s}) ltcnf

    ltgen : List (TreeS G s)
    ltgen = Data.List.map (snd G wf s) ltgen'



genparse' : (G : Grammar) → well-formed G → (s : List T) 
  → List (TreeS (normS G) s)
genparse' G wf s = ltgen'
  where
    G' = normS G -- normalized G
    cnf = progress G wf -- G' is in cnf
    GCNF = Gen2CNF G' cnf

    ltcnf : List (TreeCNF GCNF s 0 (length s) (Λ-NT GCNF))
    ltcnf = simple-parsing-start GCNF s

    ltgen' : List (TreeS G' s)
    ltgen' = Data.List.map (tt2' G' cnf {Λ-NT GCNF} {s}) ltcnf




genparse-complete : (G : Grammar) → (wf : well-formed G) → (s : List T)
  → TreeS G s → Σ[ t ∈ TreeS G s ] t ∈ genparse G wf s
genparse-complete G wf s t = tgenb , tgenb∈
  where
   G' = normS G
   cnf = progress G wf
   GCNF = Gen2CNF G' cnf
   
   t' : TreeS G' s
   t' = cmplt G s t 

   tcnf : TreeCNF GCNF s 0 (length s) (Λ-NT GCNF)
   tcnf = tt1' G' cnf t'

   ltcnf : List (TreeCNF GCNF s 0 (length s) (Λ-NT GCNF))
   ltcnf = simple-parsing-start GCNF s

   tcnf∈ : tcnf ∈ ltcnf
   tcnf∈ = simple-parsing-start-complete GCNF s tcnf 

   tcnfb : TreeS G' s
   tcnfb = tt2' G' cnf tcnf

   ltgen' : List (TreeS G' s)
   ltgen' = Data.List.map (tt2' G' cnf {Λ-NT GCNF} {s}) ltcnf

   tcnfb∈ : tcnfb ∈ ltgen'
   tcnfb∈ = ex1_comp' tcnf ltcnf  (tt2' G' cnf {Λ-NT GCNF} {s}) tcnf∈ 

   tgenb : TreeS G s
   tgenb = snd G wf s tcnfb

   ltgen : List (TreeS G s)
   ltgen = Data.List.map (snd G wf s) ltgen'

   tgenb∈ : tgenb ∈ ltgen
   tgenb∈ = ex1_comp' tcnfb ltgen' (snd G wf s) tcnfb∈ 

