

open import Relation.Nullary
open import Relation.Binary.PropositionalEquality hiding ([_]; inspect)

open import Utils.Logic

module GeneralParsing.GrammarFin  (N T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) where

open import Data.Bool hiding (T)
open import Data.Product
open import Data.Sum
open import Data.List

open import Fin.FiniteSubset
open import Fin.Finiteness

open import CNF.Grammar N T _=n_ _=t_

open import Utils.ListsAddition
open import Utils.ListMembership
open import Utils.ListProperties


record GrammarFin : Set where
  constructor ⟪_,_⟫
  field
    SF  : N
    Rule-Desc : FiniteSubSet Rule _=R?_ true

  RuleFin : Set
  RuleFin = Element Rule-Desc

  RulesFin : Listable RuleFin
  RulesFin = fsListable Rule-Desc

  RHS-Ns-Fin : List N
  RHS-Ns-Fin = RHS (listOf Rule-Desc)

  _=RF?_ : DecEq RuleFin
  _=RF?_ = fsEq Rule-Desc

  projₗ : RuleFin → N
  projₗ (r , _) = proj₁ r

  projᵣ : RuleFin → Symbols
  projᵣ (r , _) = proj₂ r

open GrammarFin public


well-formed-fin : (G : GrammarFin) → Set
well-formed-fin G 
  = inj₁ (SF G) ∈ filterAllSmbls (listOf (Rule-Desc G))


well-formed-fin-dec : (G : GrammarFin) → Dec (well-formed-fin G)
well-formed-fin-dec ⟪ SF , fs-plain desc ⟫  = eq2in (dsum-eq _=n_ _=t_) (inj₁ SF) _


isCNF-Fin : GrammarFin → Set
isCNF-Fin GF = (r : RuleFin GF) → 
          (((Σ[ n₁ ∈ N ] Σ[ n₂ ∈ N ] (projᵣ GF r) ≡ (inj₁ n₁ ∷ inj₁ n₂ ∷ [])) ⊎ 
            (Σ[ t ∈ T ] (projᵣ GF r) ≡ [ inj₂ t ] )) ⊎ 
            (projᵣ GF r ≡ [] × projₗ GF r ≡ (SF GF))) ×
          (SF GF) ∉ RHS-Ns-Fin GF 




