


open import Relation.Binary
open import Relation.Nullary
open import Relation.Binary.PropositionalEquality 
            hiding ([_]; inspect)

module GeneralParsing.GrammarFin2GrammarGen  (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T})) where

open import Data.Bool hiding (T)
open import Data.Product

open import Fin.FiniteSubset
open import Fin.Finiteness
open import Utils.Logic

open import GeneralParsing.GrammarFin N T _=n_ _=t_
open import CNF.ParseTree N T _=n_ _=t_
open import Data.Product
open import Utils.ListMembership
open import CNF.Grammar N T _=n_ _=t_ renaming (Grammar to GrammarGen)

open import Utils.ListProperties

Fin2Gen : GrammarFin → GrammarGen
Fin2Gen ⟪ st , fs-plain desc ⟫ = ⟨ st , desc ⟩

Gen2Fin : GrammarGen → GrammarFin
Gen2Fin ⟨ st , desc ⟩ =  ⟪ st , fs-plain desc ⟫


--open GrammarFin
open import Data.Sum
open import Data.Empty
open import Data.Product
open import Data.List
open import Utils.ListsAddition

prop : (P : Rule → Set) → (G : GrammarGen) → ((A : N) → (rhs : Symbols) 
   → (A , rhs) ∈ (Rs G) → P (A , rhs)) 
   → (r : (RuleFin (Gen2Fin G))) → P (projₗ (Gen2Fin G) r , projᵣ (Gen2Fin G) r)
prop P ⟨ st , de ⟩  pr ((l , r) , proof) = pr l  r (∥-∥-yes _ {proof})

cnf-prop : (G : GrammarGen) → isCNF G → isCNF-Fin (Gen2Fin G)
cnf-prop G cnf (r , proof) with ∥-∥-yes _ {proof} 
cnf-prop G cnf ((A , rhs) , proof) | inp = cnf A rhs inp
