

open import Relation.Binary
open import Relation.Nullary
open import Relation.Binary.PropositionalEquality hiding ([_]; inspect)

open import Data.List
open import Utils.ListMembership
open import Utils.Logic

module GeneralParsing.GrammarFinNorm (N T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) 
  (newntlst : List N → N)  
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns) where
   
open import Data.Sum
open import Data.Empty
open import Data.Product
open import Data.List

open import GeneralParsing.GrammarFin N T _=n_ _=t_

open import GeneralParsing.GrammarFinTree N T _=n_ _=t_ 
open import GeneralParsing.GrammarFin2GrammarGen N T _=n_ _=t_
open import GeneralParsing.TreeFin2TreeGen N T _=n_ _=t_ newntlst newntlstlem

open import Fin.FiniteSubset

open import CNF.ParseTree N T _=n_ _=t_
open import CNF.Grammar N T _=n_ _=t_ renaming (Grammar to GrammarGen)
open import CNF.NormGrammar N T _=n_ _=t_ newntlst newntlstlem

open import Utils.ListMembership
open import Utils.ListsAddition
open import Utils.ListProperties

norm-fin : GrammarFin → GrammarFin
norm-fin GF = Gen2Fin (normS (Fin2Gen GF))


norm-fin-progress : (G : GrammarFin) → well-formed-fin G → isCNF-Fin (norm-fin G)
norm-fin-progress ⟪ as , (fs-plain desc) ⟫ wf = cnf-prop GFGN (progress GFG wf)
  where
    GFG = Fin2Gen ⟪ as , (fs-plain desc) ⟫
    GFGN = normS GFG
    GL   = Gen2Fin GFGN


norm-fin-complete : (G : GrammarFin) →  (s : List T) → TreeFin G (SF G) s 
   → TreeFin (norm-fin G) (SF (norm-fin G)) s
norm-fin-complete ⟪ SF , fs-plain desc ⟫  s t = gen2fin tngen
  where
    tgen = fin2gen t
    tngen = cmplt _ s tgen


norm-fin-sound : (G : GrammarFin) →  (s : List T) → well-formed-fin G
  → TreeFin (norm-fin G) (SF (norm-fin G)) s
  → TreeFin G (SF G) s 
norm-fin-sound ⟪ SF , fs-plain desc ⟫  s wf t = gen2fin tngen
  where
    tgen = fin2gen t
    tngen = snd _ wf s tgen
