
open import Relation.Binary
open import Relation.Nullary
open import Relation.Binary.PropositionalEquality 
            hiding ([_])

open import Utils.Logic

module GeneralParsing.GrammarFinTree (N T : Set)(_=n_ : DecEq N)(_=t_ : DecEq T) where

open import Data.List hiding (all)
open import Data.List.All hiding (all)
open import Data.List.Properties
open import Data.Product
open import Data.Sum 
open import Data.Empty
open import Data.Nat hiding (_≟_)

open import Utils.ListsAddition
open import Utils.ListProperties

open import GeneralParsing.GrammarFin N T _=n_ _=t_

open import CNF.ParseTree N T _=n_ _=t_
open import CNF.Grammar N T _=n_ _=t_


mutual 
  data TreeFin (G : GrammarFin) : N → List T → Set where
     node : ∀ {ys} → (r : RuleFin G)
                        → ListOfTsFin G (projᵣ G r) ys → TreeFin G (projₗ G r) ys

  data ListOfTsFin (G : GrammarFin) : Symbols → List T → Set where
    ⟦⟧    : ListOfTsFin G [] []
    _∷t_  : ∀ {xs ys} → (t : T) → ListOfTsFin G xs ys
                      → ListOfTsFin G (inj₂ t ∷ xs) (t ∷ ys)
    _∷n_  : ∀ {xs ys n zs} → TreeFin G n zs → ListOfTsFin G xs ys
                      → ListOfTsFin G (inj₁ n ∷ xs) (zs ++ ys)


TreeFinS : GrammarFin → List T → Set
TreeFinS G s = TreeFin G (SF G) s

converter : {G : GrammarFin}{s : List T} → List (Σ[ A ∈ N ] TreeFin G A s) → List (TreeFinS G s)
converter {⟪ SF , Rule-Desc ⟫} [] = []
converter {⟪ SF , Rule-Desc ⟫} ((a , t) ∷ l) with a =n SF 
converter {⟪ .SF , Rule-Desc ⟫} ((SF , t) ∷ l) | yes refl = t ∷ converter l
converter {⟪ SF , Rule-Desc ⟫} ((a , t) ∷ l) | no ¬p = converter l

