


module GeneralParsing.GrammarFinTreePrinter where

open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect)

open import Data.Product
open import Data.Sum
open import Data.List
open import Data.Nat.Show 
open import Data.Char renaming (_≟_ to _=C?_)
open import Data.String renaming (_++_ to _++s_) hiding (_≟_)
open import Data.Colist renaming (take to takec) hiding (length ; [_] ; _++_)
open import Data.BoundedVec.Inefficient renaming (toList to toListb)

open import Function

open import Foreign.Haskell
open import IO.Primitive

open import CNF.NormStringInstance
open import CNF.Grammar StringC Char _=S?_ _=C?_ renaming (_≟_ to _=Rule?_)

open import Fin.FiniteSubset

open import GeneralParsing.GrammarFin StringC Char _=S?_ _=C?_
open import GeneralParsing.GrammarFinTree StringC Char _=S?_ _=C?_ 
open import GeneralParsing.FinParsing StringC Char _=S?_ _=C?_  newntlst newntlstlem

open import Utils.Logic

symbs2str : Symbols → StringC
symbs2str [] = []
symbs2str (inj₁ x ∷ []) = x
symbs2str (inj₁ x ∷ s) = x ++ [ '∙' ] ++ symbs2str s
symbs2str (inj₂ y ∷ s) = y ∷ symbs2str s
open import Data.Nat

indent : ℕ → StringC
indent zero = []
indent (suc n) = ′ "  " ′  ++ indent n

mutual
 tostr' : {G : GrammarFin}{A : StringC}{s : StringC} → TreeFin G A s → ℕ → StringC
 tostr' {G} (node r x) n =  indent n

      ++ projₗ G r  ++ [ '→' ] ++ symbs2str (projᵣ G r)  ++ [ '\n' ]   ++ tostr-mut x  (suc n)


 tostr-mut : {G : GrammarFin}{rhs : Symbols}{s : StringC} → ListOfTsFin G rhs s → ℕ → StringC
 tostr-mut  ⟦⟧ n = []
 tostr-mut  (t ∷t l) n = tostr-mut l n
 tostr-mut  (x ∷n l) n = tostr' x n  ++ tostr-mut l n

tostr : {G : GrammarFin}{A : StringC}{s : StringC} → TreeFin G A s → StringC
tostr t = tostr' t 0


gtostr : Rules → StringC
gtostr [] = []
gtostr ((proj₁ , proj₂) ∷ xs) = proj₁ ++ [ '→' ] ++ symbs2str proj₂ ++ [ '\n' ] ++ gtostr xs


gftostr : Grammar → StringC
gftostr ⟨ S , Rs ⟩ = 'S' ∷ ':' ∷ [] ++ S ++ [ '\n' ] ++ gtostr Rs


