


open import Relation.Binary
open import Relation.Nullary
open import Relation.Binary.PropositionalEquality 
            hiding ([_]; inspect)
open import Data.List
open import Data.Product
open import Data.Sum
open import Data.Bool
open import Utils.ListsAddition
open import Utils.ListProperties

module GeneralParsing.GrammarGen2GrammarCNF
  (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T})) where


open import CNF.Grammar N T _=n_ _=t_ renaming (Rules to RulesGen ; Rule to RuleGen)
open import CNF.ParseTree N T _=n_ _=t_ 

open import CYK.GrammarCNF N T _=n_ _=t_ renaming (Rules to RulesCNF ; Rule to RuleCNF)


r2nf : RuleGen → RulesCNF
r2nf (A , []) = []
r2nf (A , inj₂ t ∷ []) =  [ A ─> t ]
r2nf (A , inj₁ B ∷ inj₁ C ∷ []) =  [ A ─> B ∙ C ]
r2nf _ = []

2nf : RulesGen → RulesCNF
2nf [] = []
2nf (r ∷ rs) = r2nf r ++ 2nf rs


2nf-t1 : {A : N}{t : T} → (RsG : RulesGen) →  (A , [ inj₂ t ]) ∈ RsG → A ─> t ∈ 2nf RsG
2nf-t1 ._ here = here
2nf-t1 (r ∷ RsG') (there prf) with 2nf-t1  _ prf 
... | IH = exists-duo _ _ (r2nf r) IH

2nf-t2 : {A : N}{t : T} → (RsG : RulesGen) → A ─> t ∈ 2nf RsG → (A , [ inj₂ t ]) ∈ RsG 
2nf-t2 [] ()
2nf-t2 (x ∷ RsG) pri with incLem {a = r2nf x} {b = 2nf RsG} pri 
2nf-t2 ((A₁ , []) ∷ RsG) pri | inj₁ ()
2nf-t2 ((A₁ , inj₁ x ∷ []) ∷ RsG) pri | inj₁ ()
2nf-t2 ((A₁ , inj₁ x ∷ inj₁ x₁ ∷ []) ∷ RsG) pri | inj₁ (there ())
2nf-t2 ((A₁ , inj₁ x ∷ inj₁ x₁ ∷ x₂ ∷ proj₂) ∷ RsG) pri | inj₁ ()

2nf-t2 ((A₁ , inj₁ x ∷ inj₂ y ∷ proj₂) ∷ RsG) pri | inj₁ ()
2nf-t2 ((A₁ , inj₂ y ∷ []) ∷ RsG) pri | inj₁ here = here
2nf-t2 ((A₁ , inj₂ y ∷ []) ∷ RsG) pri | inj₁ (there ())
2nf-t2 ((A₁ , inj₂ y ∷ x ∷ proj₂) ∷ RsG) pri | inj₁ ()
2nf-t2 (x ∷ RsG) pri | inj₂ y = there (2nf-t2 RsG y)


2nf-n1 : {A B C : N} → (RsG : RulesGen) →  (A , (inj₁ B ∷ inj₁ C ∷ [])) ∈ RsG 
    → A ─> B ∙ C ∈ 2nf RsG
2nf-n1 ._ here = here
2nf-n1 (r ∷ RsG') (there pi) = exists-duo _ _ (r2nf r) (2nf-n1 RsG' pi)


2nf-n2 : {A B C : N} → (RsG : RulesGen) →  A ─> B ∙ C ∈ 2nf RsG 
    → (A , (inj₁ B ∷ inj₁ C ∷ [])) ∈ RsG 
2nf-n2 [] ()
2nf-n2 (x ∷ RsG) pi with incLem {a = r2nf x} {b = 2nf RsG} pi
2nf-n2 ((A₁ , []) ∷ RsG) pi | inj₁ ()
2nf-n2 ((A₁ , inj₁ x ∷ []) ∷ RsG) pi | inj₁ ()
2nf-n2 ((A , inj₁ x ∷ inj₁ x₁ ∷ []) ∷ RsG) pi | inj₁ here = here
2nf-n2 ((A₁ , inj₁ x ∷ inj₁ x₁ ∷ []) ∷ RsG) pi | inj₁ (there ())
2nf-n2 ((A₁ , inj₁ x ∷ inj₁ x₁ ∷ x₂ ∷ proj₂) ∷ RsG) pi | inj₁ ()
2nf-n2 ((A₁ , inj₁ x ∷ inj₂ y ∷ proj₂) ∷ RsG) pi | inj₁ ()
2nf-n2 ((A₁ , inj₂ y ∷ []) ∷ RsG) pi | inj₁ (there ())
2nf-n2 ((A₁ , inj₂ y ∷ x ∷ proj₂) ∷ RsG) pi | inj₁ ()

2nf-n2 (x ∷ RsG) pi | inj₂ y = there (2nf-n2 RsG y)


open import Utils.Logic
open import Utils.ListProperties
open import Data.Empty

nullability : RulesGen → N → Bool
nullability rs A = dec2bool (eq2in _=R?_ (A , []) rs)


2nf-[]1 : (RsG : RulesGen) → (A : N) → (A , []) ∈ RsG → nullability RsG A ≡ true
2nf-[]1 RsG A inp with (eq2in _=R?_ (A , []) RsG) 
2nf-[]1 RsG A inp | yes p = refl
2nf-[]1 RsG A inp | no ¬p = ex-falso-quodlibet (¬p inp)

2nf-[]2 : (RsG : RulesGen) → (A : N) → nullability RsG A ≡ true → (A , []) ∈ RsG
2nf-[]2 RsG A npt with (eq2in _=R?_ (A , []) RsG) 
2nf-[]2 RsG A npt | yes p = p
2nf-[]2 RsG A () | no ¬p 

2nf-sp1 : (RsG : RulesGen) → (A : N) → 
     ((B : N) → (rhs : Symbols) → (B , rhs) ∈ RsG → (inj₁ A) ∉ rhs)
     → (B C : N) → (B ─> A ∙ C) ∉ (2nf RsG)
2nf-sp1 RsG A prop B C pin  with 2nf-n2 RsG  pin 
... | Ai = prop B _ Ai here

2nf-sp2 : (RsG : RulesGen) → (A : N) → 
     ((B : N) → (rhs : Symbols) → (B , rhs) ∈ RsG → (inj₁ A) ∉ rhs)
     → (B C : N) → (B ─> C ∙ A) ∉ (2nf RsG)
2nf-sp2 RsG A prop B C pin  with 2nf-n2 RsG  pin 
... | Ai = prop B _ Ai (there here)


RHS-corr-help : (A : N) → (rhs : Symbols) → inj₁ A ∈ rhs → A ∈ NTs' rhs
RHS-corr-help A ._ here = here
RHS-corr-help A (inj₁ x ∷ rhs) (there ip) = there (RHS-corr-help A rhs ip)
RHS-corr-help A (inj₂ y ∷ rhs) (there ip) = RHS-corr-help A rhs ip

RHS-corr-help2 : (A S : N) → (rhs : Symbols) → (rules : RulesGen) → (A , rhs) ∈ rules → (inj₁ S) ∈ rhs  → S ∈ RHS rules
RHS-corr-help2 A S rhs (.(A , rhs) ∷ rs) here pi2 = ∈-weak-rgt {b = RHS rs} {NTs' rhs} {S} (RHS-corr-help S rhs  pi2)
RHS-corr-help2 A S rhs ((proj₁ , proj₂) ∷ rs) (there pi) pi2 = ∈-weak-lft {xs₁ = NTs' proj₂} {xs₂ = RHS rs} {S} (RHS-corr-help2 A S rhs rs pi pi2)

RHS-corr : (RsG : RulesGen) → (A : N) → A ∉ RHS RsG 
  → ((B : N) → (rhs : Symbols) → (B , rhs) ∈ RsG → (inj₁ A) ∉ rhs)
RHS-corr (.(B , rhs) ∷ RsG) A p B rhs here bni = p (∈-weak-rgt {b = RHS RsG}{c = NTs' rhs} {a = A} (RHS-corr-help A rhs bni) )

RHS-corr ((x , x₁) ∷ RsG) A p B rhs (there bi) bni = RHS-corr _ A (λ q → p (exists-duo A (RHS RsG) (NTs' x₁) q)) B rhs bi bni


Gen2CNF : (G : Grammar) → isCNF G → GrammarCNF
Gen2CNF ⟨ S , rules ⟩ cnf = record {
   Λ-NT = S ;
   Nullable? = nullability rules S   ;
   Rs = 2nf rules ;
   Λ-NT-Rule1 = 2nf-sp1 rules S (λ b rhs bri si → proj₂ (cnf b rhs bri) (RHS-corr-help2 b S rhs rules bri si) ) _ _ ;
   Λ-NT-Rule2 = 2nf-sp2 rules S (λ b rhs bri si → proj₂ (cnf b rhs bri) (RHS-corr-help2 b S rhs rules bri si) ) _ _
 }
