


open import Relation.Binary
open import Relation.Nullary
open import Relation.Binary.PropositionalEquality 
            hiding ([_]; inspect)
open import Data.List
open import Data.Product
open import Data.Sum
open import Data.Bool
open import Data.Nat
open import Utils.ListsAddition
open import Utils.ListProperties

module GeneralParsing.TreeFin2TreeGen  (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T})) 
 (newntlst : List N → N)  
  (newntlstlem : (ns : List N) → (newntlst ns) ∉ ns)
  where

open import Fin.FiniteSubset
open import Fin.Finiteness

open import Utils.Logic
open import Utils.ListMembership

open import GeneralParsing.GrammarFin N T _=n_ _=t_
open import GeneralParsing.GrammarFinTree N T _=n_ _=t_
open import GeneralParsing.GrammarFin2GrammarGen  N T _=n_ _=t_

open import CNF.ParseTree N T _=n_ _=t_
open import CNF.Grammar N T _=n_ _=t_ renaming (Grammar to GrammarGen)
open import CNF.NormGrammar N T _=n_ _=t_  newntlst newntlstlem

open GrammarFin


mutual 

  fin2gen : {G : GrammarFin}{A : N}{s : List T} → TreeFin G A s → TreeGen (Fin2Gen G) A s
  fin2gen {⟪ SF , fs-plain desc ⟫} (node ((l , r) , proof) x) 
       = node (∥-∥-yes _ {proof}) (fin2gen-mut x)

  fin2gen-mut : {G : GrammarFin}{xs : Symbols}{s : List T} → ListOfTsFin G xs s
    → ListOfTsGen (Fin2Gen G) xs s 
  fin2gen-mut {⟪ SF , Rule-Desc ⟫} ⟦⟧ = ⟦⟧
  fin2gen-mut {⟪ SF , Rule-Desc ⟫} (t ∷t l) = t ∷t fin2gen-mut l
  fin2gen-mut {⟪ SF , Rule-Desc ⟫} (x ∷n l) = fin2gen x ∷n fin2gen-mut l



mutual 

  gen2fin : {G : GrammarFin}{A : N}{s : List T} → TreeGen (Fin2Gen G) A s → TreeFin G A s 
  gen2fin {⟪ SF , fs-plain desc ⟫} (node {xs} {ys} {A} x x₁) = node ((A , xs) , ∥-∥-prop2 x ((eq2in _=R?_ (A , xs) desc))) (gen2fin-mut x₁)

  gen2fin-mut : {G : GrammarFin}{xs : Symbols}{s : List T} 
    → ListOfTsGen (Fin2Gen G) xs s  → ListOfTsFin G xs s
  gen2fin-mut {⟪ SF , Rule-Desc ⟫} ⟦⟧ = ⟦⟧
  gen2fin-mut {⟪ SF , Rule-Desc ⟫} (t ∷t l) = t ∷t gen2fin-mut l
  gen2fin-mut {⟪ SF , Rule-Desc ⟫} (x ∷n l) = gen2fin x ∷n gen2fin-mut l
