
open import Relation.Binary
open import Relation.Nullary
open import Relation.Binary.PropositionalEquality hiding ([_]; inspect)
open import Data.List
open import Data.Product
open import Data.Sum
open import Data.Bool

open import Utils.ListsAddition
open import Utils.ListProperties

module GeneralParsing.TreeGen2TreeCNF
  (N T : Set)(_=n_ : Decidable (_≡_ {A = N}))(_=t_ : Decidable (_≡_ {A = T})) where


open import CNF.Grammar N T _=n_ _=t_ renaming (Rules to RulesGen ; Rule to RuleGen)
open import CNF.ParseTree N T _=n_ _=t_ 

open import CYK.ParseTreeWrapper N T _=n_ _=t_ 
open import CYK.GrammarCNF N T _=n_ _=t_ renaming (Rules to RulesCNF ; Rule to RuleCNF)

open import GeneralParsing.GrammarGen2GrammarCNF N T _=n_ _=t_ 



tt1 : (G : Grammar) → (cnf : isCNF G) → {A : N}{s : List T} 
  → Tree (Rs G) A s
  → _◂_  (Gen2CNF G cnf) s A
tt1 G cnf {A} {s} (node {rhs} x x₁) with cnf A rhs x
tt1 G cnf (node x (t' ∷n (_∷n_ {zs = zs} t'' ⟦⟧))) | inj₁ (inj₁ (B , C , refl)) , pr with 
   tt1 G cnf t'  | tt1 G cnf t''
... | tcnf' | tcnf''  rewrite ++-th zs  = cons' (2nf-n1 (Rs G) x) tcnf' tcnf'' 
tt1 G cnf (node x (t ∷t ⟦⟧)) | inj₁ (inj₂ (.t , refl)) , pr = sngl' (2nf-t1 (Rs G) x)
tt1 G cnf (node x ⟦⟧) | inj₂ (refl , refl) , pr = empt' (2nf-[]1 (Rs G) _ x)

tt2 : (G : Grammar) → (cnf : isCNF G) → {A : N}{s : List T} 
   → _◂_  (Gen2CNF G cnf) s A
   → Tree (Rs G) A s 
tt2 G cnf (empt' x) = node  (2nf-[]2 (Rs G) _ x) ⟦⟧
tt2 G cnf (sngl' x) = node (2nf-t2 (Rs G) x) (_∷t_  _ ⟦⟧)
tt2 G cnf (cons' {s₂ = s''} x t t₁) with tt2 G cnf t | tt2 G cnf t₁
... | tgen' | tgen'' with node (2nf-n2 (Rs G) x) (_∷n_ tgen' (_∷n_ tgen'' ⟦⟧)) 
... | tr rewrite ++-th s'' = tr

open import CYK.ParseTree N T _=n_ _=t_ renaming (_[_,_[◂_ to TreeCNF)


open import Data.Nat

lenl : (n : ℕ) → n ≤ n
lenl zero = z≤n
lenl (suc n) = s≤s (lenl n)

tt1' : (G : Grammar) → (cnf : isCNF G) → {A : N}{s : List T} 
  → Tree (Rs G) A s
  → TreeCNF (Gen2CNF G cnf) s 0 (length s) A
tt1' G cnf {A} {s} t  = convlem (Gen2CNF G cnf) A s s 0  (length s) (lenl _) (tt1 G cnf {A} {s} t) (sublemma (Gen2CNF G cnf) s)

tt2' : (G : Grammar) → (cnf : isCNF G) → {A : N}{s : List T} 
  → TreeCNF (Gen2CNF G cnf) s 0 (length s) A
  → Tree (Rs G) A s
tt2' G cnf {A} {s} t with lemconv (Gen2CNF G cnf) A s  (length s) 0 (length s) t refl 
... | IT rewrite sublemma (Gen2CNF G cnf) s = tt2 G cnf {A} {s} IT

