

module Utils.ListMembership where

open import Data.List
open import Level

infix 5 _∈_
data _∈_ {a} {A : Set a} : A → List A → Set a where
  here  : ∀ {x}   {xs : List A} → x ∈ (x ∷ xs)
  there : ∀ {x y} {xs : List A} (x∈xs : x ∈ xs) → x ∈ (y ∷ xs)



open import Data.Empty
infix 5 _∉_
_∉_ : {X : Set} → X → List X → Set
_∉_ x xs = x ∈ xs → ⊥
