

module Utils.ListMonad where

open import Data.List
open import Data.Product
open import Data.List renaming (_++_ to _+++_)
open import Data.Sum

open import Relation.Binary.PropositionalEquality hiding ([_])

open import Utils.ListProperties

-- `bind`
_>>=ₗ_ : {A B : Set} → List A → (A → List B) → List B
_>>=ₗ_ l f = foldl (λ res el →  res ++ f el) [] l


_>>=_ : {A B : Set} → List A → (A → List B) → List B
_>>=_ l f = foldr (λ el res →  f el ++ res) [] l




>>=split : {A B : Set} → (a b : List A) → (f : A → List B) →  (a ++ b) >>= f ≡ (a >>= f) ++ (b >>= f) 
>>=split [] b f = refl
>>=split (x ∷ a) b f rewrite >>=split a b f 
   = ++-assoc (f x) (a >>= f)  (b >>= f)


l≡r : {A B : Set} → (xs : List A) → (f : A → List B) → xs >>= f ≡ xs >>=ₗ f
l≡r [] f = refl
l≡r (x ∷ xs) f rewrite foldl-unf (f x ++ []) xs f | ++-rgt-id (f x) 
  | foldl-unf (f x) xs f  = cong (_++_ (f x)) (l≡r xs f)

-- `unit`
return : {A : Set} → A → List A
return a = [ a ]


>>=distrₗ : {A B : Set} → (a b : List A) → (f : A → List B)
 →  (a ++ b) >>=ₗ f ≡ (a >>=ₗ f) ++ (b >>=ₗ f) 
>>=distrₗ [] b f = refl
>>=distrₗ (x ∷ a) b f rewrite foldl-unf (f x) (a ++ b) f 
 | foldl-unf (f x) a f 
 | sym (++-assoc (f x) (a >>=ₗ f) (b >>=ₗ f)) 
 | >>=distrₗ a b f = refl

>>=distr : {A B : Set} → (a b : List A) → (f : A → List B)
 →  (a ++ b) >>= f ≡ (a >>= f) ++ (b >>= f) 
>>=distr a b f rewrite l≡r (a ++ b) f 
 | l≡r a f 
 | l≡r b f = >>=distrₗ a b f 


{- monad laws-}

-- left identity
left-id-lawₗ :  {A B : Set} →  (a : A) →  (f : A → List B)
  → return a >>=ₗ f ≡ f a
left-id-lawₗ a f = refl 

left-id-law :  {A B : Set} →  (a : A) →  (f : A → List B)  → return a >>= f ≡  f a
left-id-law a f rewrite l≡r (return a) f = left-id-lawₗ a f 

-- right identity
right-id-lawₗ : {A : Set} → (m : List A) →  m >>=ₗ return ≡ m
right-id-lawₗ [] = refl
right-id-lawₗ (x ∷ m) rewrite foldl-unf (x ∷ []) m return = cong (_∷_ x) (right-id-lawₗ m) 

right-id-law : {A : Set} → (m : List A) →  m >>= return ≡ m
right-id-law m rewrite l≡r m return = right-id-lawₗ m 




-- associativity
assocₗ : {A B C : Set}  → (m : List A) → (f : A → List B)
  → (g : B → List C)
  → (m >>=ₗ f) >>=ₗ g ≡ m >>=ₗ (λ x → f x >>=ₗ g)
assocₗ [] f g = refl
assocₗ (x ∷ m) f g rewrite foldl-unf (f x) m f
 | foldl-unf ((f x) >>=ₗ g) m (λ x → f x >>=ₗ g)  
 | >>=distrₗ (f x) (m >>=ₗ f) g  
 | assocₗ m f g = refl 

assoc : {A B C : Set}  → (m : List A) → (f : A → List B)
  → (g : B → List C)
  → (m >>= f) >>= g ≡ m >>= (λ x → f x >>= g)
assoc [] f g = refl
assoc (x ∷ m) f g rewrite l≡r (x ∷ m) (λ x → f x >>= g) | l≡r (f x) g | foldl-unf (f x >>=ₗ g) m (λ x → f x >>= g) | sym (l≡r m (λ x → f x >>= g)) | sym (assoc m f g) | l≡r (x ∷ m) f |  l≡r ((x ∷ m) >>=ₗ f) g | l≡r m f | l≡r (m >>=ₗ f) g | foldl-unf (f x) m f =  >>=distrₗ (f x) (m >>=ₗ f) g 

{- some additional laws -}
>>=congₗ  : ∀ {X Y : Set} → (f g : X → List Y) → (xs : List X) → (∀ x → f x ≡ g x) → xs >>=ₗ f ≡ xs >>=ₗ g
>>=congₗ f g [] p = refl
>>=congₗ f g (x ∷ xs) p 
 rewrite >>=distrₗ [ x ] xs f
 | >>=distrₗ [ x ] xs g
 | p x 
 | >>=congₗ f g xs p = refl

>>=cong  : ∀ {X Y : Set} → (f g : X → List Y) → (xs : List X) → (∀ x → f x ≡ g x) → xs >>= f ≡ xs >>= g
>>=cong f g xs p rewrite l≡r xs f | l≡r xs g = >>=congₗ f g xs p



list-monad-htₗ : {X Y : Set}(e : Y)(xs : List X)(f : X → List Y) → (x : X)  
 → x ∈ xs
 → e ∈ f x 
 → e ∈ (xs >>=ₗ f)
list-monad-htₗ e [] f x () ein
list-monad-htₗ e (x ∷ xs) f .x here ein 
 rewrite >>=distrₗ [ x ] xs f = ∈-weak-rgt ein
list-monad-htₗ e (x ∷ xs) f x₁ (there xin) ein 
 rewrite >>=distrₗ [ x ] xs f 
 = ∈-weak-lft {_} {f x} (list-monad-htₗ e xs f x₁ xin ein)


list-monad-ht : {X Y : Set}(e : Y)(xs : List X)(f : X → List Y) → (x : X)  
 → x ∈ xs
 → e ∈ f x 
 → e ∈ (xs >>= f)
list-monad-ht e xs f x p1 p2 rewrite l≡r xs f = list-monad-htₗ e xs f x p1 p2


list-monad-thₗ : {X Y : Set}(e : Y)(xs : List X)(f : X → List Y) 
 →  e ∈ (xs >>=ₗ f) →  Σ[ x ∈ X ] x ∈ xs × e ∈ f x
list-monad-thₗ e [] f ()
list-monad-thₗ e (x ∷ xs) f ein 
 rewrite >>=distrₗ [ x ] xs f with ∈-split {_} {f x} {xs >>=ₗ f} ein
list-monad-thₗ e (x ∷ xs) f ein | inj₁ x₁ = x , here , x₁
list-monad-thₗ e (x ∷ xs) f ein | inj₂ y with list-monad-thₗ e xs f y 
... | (p1 , p2 , p3) = p1 , there p2 , p3


list-monad-th : {X Y : Set}(e : Y)(xs : List X)(f : X → List Y) 
 →  e ∈ (xs >>= f) →  Σ[ x ∈ X ] x ∈ xs × e ∈ f x
list-monad-th e xs f p1 rewrite l≡r xs f = list-monad-thₗ e xs f p1
