


module Utils.Logic where


open import Relation.Binary.PropositionalEquality hiding ([_] ; inspect)
open import Relation.Binary.Core 
open import Relation.Nullary

open import Data.Empty
open import Data.Unit
open import Data.Bool hiding (_∨_)

open import Data.List
open import Data.Empty

uip : {X : Set} → {a b : X} → (eq1 : a ≡ b) → (eq2 : a ≡ b) → eq1 ≡ eq2
uip refl refl = refl


DecEq : ∀ X → Set
DecEq X = Decidable (_≡_ {A = X})


DecEqRest : {X : Set} → (P : X → Set) → Set
DecEqRest P = ∀ x1 x2 → P x1 → P x2 → Dec (x1 ≡ x2)


∥_∥ : ∀ {p} → {S : Set p} → Dec S → Set
∥ yes _ ∥  = ⊤
∥ no  _ ∥  = ⊥

∥-∥-prop3 : {S : Set} → (d : Dec S) → ∥ d ∥ → S
∥-∥-prop3 (yes p) tt = p
∥-∥-prop3 (no p) ()

∥-∥-yes : {S : Set} → (d : Dec S) → {d : ∥ d ∥} → S
∥-∥-yes (yes p) {tt} = p
∥-∥-yes (no p) {()}

∥-∥-prop2 : {S : Set} → S → (d : Dec S) → ∥ d ∥ 
∥-∥-prop2 s (yes p) = tt
∥-∥-prop2 s (no ¬p) = ¬p s

p2p3 : {X : Set} → (d : Dec X) → (x : ∥ d ∥) → ∥-∥-prop2 (∥-∥-prop3 d x) d ≡ x
p2p3 (yes p) tt = refl
p2p3 (no ¬p) ()

{-
p3p2 : {X : Set} → (d : Dec X) → (x : X) →  ∥-∥-prop3 d (∥-∥-prop2 x d) ≡ x
p3p2 (yes p) x = {!!}
p3p2 (no ¬p) x = {!!}
-}

∥-∥-prop : {S : Set} → (d : Dec S) → (s₁ s₂ : ∥ d ∥) → s₁ ≡ s₂
∥-∥-prop (yes p) tt tt = refl
∥-∥-prop (no ¬p) () s2


dec2bool : ∀ {p} → {S : Set p} → Dec S → Bool
dec2bool (yes _) = true
dec2bool (no _)  = false



open import Data.Product
open import Data.Sum

prod-eq : {A B : Set} → Decidable (_≡_ {A = A}) → Decidable (_≡_ {A = B}) → Decidable (_≡_ {A = A × B})
prod-eq da db (proj₁ , proj₂) (proj₃ , proj₄) with da proj₁ proj₃ | db proj₂ proj₄ 
prod-eq da db (proj₁ , proj₂) (.proj₁ , .proj₂) | yes refl | yes refl = yes refl
prod-eq da db (proj₁ , proj2) (.proj₁ , proj₄) | yes refl | no ¬p = no (λ pr → ¬p (cong proj₂ pr))
prod-eq da db (proj1 , proj2) (proj₃ , .proj2) | no ¬p | yes refl = no (λ pr → ¬p (cong proj₁ pr))
prod-eq da db (proj₁ , proj2) (proj₃ , proj₄) | no ¬p | no ¬p₁ = no (λ pr → ¬p₁ (cong proj₂ pr))


dsum-eq : {A B : Set} → Decidable (_≡_ {A = A}) → Decidable (_≡_ {A = B}) → Decidable (_≡_ {A = A ⊎ B})
dsum-eq da db (inj₁ x) (inj₁ x₁) with da x x₁ 
dsum-eq da db (inj₁ x) (inj₁ .x) | yes refl = yes refl
dsum-eq da db (inj₁ x) (inj₁ x₁) | no ¬p = no (λ pr → ¬p (cong (λ { (inj₁ z) → z ; (inj₂ _) → x }) pr))
dsum-eq da db (inj₁ x) (inj₂ y) = no (λ { () })
dsum-eq da db (inj₂ y) (inj₁ x) = no (λ { () })
dsum-eq da db (inj₂ y) (inj₂ y₁) with db y y₁ 
dsum-eq da db (inj₂ y) (inj₂ .y) | yes refl = yes refl
dsum-eq da db (inj₂ y) (inj₂ y₁) | no ¬p = no (λ pr → ¬p (cong (λ { (inj₂ z) → z ; (inj₁ _) → y }) pr))


deq2lists : {X : Set} → DecEq X → DecEq (List X)
deq2lists d [] [] = yes refl
deq2lists d [] (x ∷ y) = no (λ ())
deq2lists d (x ∷ ls) [] = no (λ ())
deq2lists d (x ∷ ls) (x₁ ∷ y) with d x x₁ 
deq2lists d (x ∷ ls) (.x ∷ y) | yes refl with deq2lists d ls y 
deq2lists d (x ∷ ls) (.x ∷ .ls) | yes refl | yes refl = yes refl
deq2lists d (x ∷ ls) (.x ∷ y) | yes refl | no ¬p = no (λ q → ¬p (cong (drop 1) q) )
deq2lists d (x ∷ ls) (x₁ ∷ y) | no ¬p = no (λ q → ¬p (cong (λ {  (x₂ ∷ ws) → x₂ ; [] → x₁ }) q))



_≠_ : {X : Set} → (a b : X) → Set
_≠_ a b = a ≢ b 


ex-falso-quodlibet : {p : Set}(x : ⊥) → p
ex-falso-quodlibet ()


{-
infix 3 _∨_ 
data _∨_  (A B : Set) : Set where
 inl : A → A ∨ B
 inr : B → A ∨ B
-}

--_∨_ = _⊎_

data Inspect {A : Set}(x : A) : Set where
  it : (y : A) → x ≡ y → Inspect x

inspect : {A : Set}(x : A) → Inspect x
inspect x = it x refl


Rel' : Set → Set₁
Rel' A = A → A → Set

module WF< where

  open import Data.Nat 

  letn : (n : ℕ) → n < (suc n)
  letn zero = s≤s z≤n
  letn (suc n) = s≤s (letn n) 


  module WF {A : Set} (_<_ : Rel' A) where
    data Acc (x : A) : Set where
      acc : (∀ y → y < x → Acc y) → Acc x


    Well-founded : Set
    Well-founded = ∀ x → Acc x


  open WF _<_ public
  open import Utils.NatProperties

  <-ℕ-wf : WF.Well-founded _<_
  <-ℕ-wf x = acc (aux x)
     where
       aux : (x y : ℕ) → y < x → Acc y
       aux ._ .0 (s≤s {zero} p) = acc (λ { i () })
       aux .(suc n) .(suc m) (s≤s {suc m} {n} p) with <-ℕ-wf n 
       ... | (acc q) = acc (λ i ip → q i (trans≤ _ _ _ ip p))


  module Inverse-image-Well-founded { A B }
    (_<_ : Rel' B)(f : A → B) where
    _⊰_ : Rel' A
    x ⊰ y = f x < f y


    ii-acc : ∀ {x} → WF.Acc _<_ (f x) → WF.Acc _⊰_ x
    ii-acc (WF.acc g) = WF.acc (λ y fy<fx → ii-acc (g (f y) fy<fx))
    -- unwraps and then wraps it up again!


    ii-wf : WF.Well-founded _<_ → WF.Well-founded _⊰_
    ii-wf wf x = ii-acc (wf (f x))


  module <-on-length-Well-founded { A } where
    open Inverse-image-Well-founded { List A } _<_ length public
    wf : WF.Well-founded _⊰_
    wf = ii-wf <-ℕ-wf



open import Data.Bool hiding (_∨_ ; _≟_)

ab : ∀ {a b} → a ∧ b ≡ true → a ≡ true
ab {true} {true} p = refl
ab {false} {true} ()
ab {true} {false} ()
ab {false} {false} ()


bb' : ∀ {a b} → a ∧ b ≡ true → b ≡ true
bb' {a} {true} p = refl
bb' {true} {false} ()
bb' {false} {false} ()


open import Utils.ArithmeticProperties
open import Data.Nat hiding (_<_)
data Acc (x : ℕ) : Set₁ where
  acc : (∀ y → y < x → Acc y) → Acc x


Well-founded : Set₁
Well-founded = ∀ x → Acc x


mutual 
 aux : ∀ x y → y < x → Acc  y
 aux .(suc y) y <-base = <-ℕ-wf y
 aux .(suc x) y (<-step {x} y<x) = aux x y y<x

 <-ℕ-wf : ∀ x → Acc x
 <-ℕ-wf x = acc (aux x)
