

module Utils.NatProperties where

open import Data.Nat

open import Relation.Binary.PropositionalEquality hiding (inspect)
open import Relation.Binary.Core 
open import Relation.Nullary


+-com : ∀ a b → a + b ≡ b + a
+-com zero zero = refl
+-com zero (suc b) = cong suc (+-com zero b)
+-com (suc a) zero = cong suc (+-com a zero)
+-com (suc a) (suc b) rewrite +-com a (suc b) | +-com b a 
 = cong suc (+-com (suc a) b)

open import Data.Sum
≤-pr : ∀ a b → ¬ (a ≡ b) → a ≤ b ⊎ b ≤ a
≤-pr zero b pr = inj₁ z≤n
≤-pr (suc a) zero pr = inj₂ z≤n
≤-pr (suc a) (suc b) pr with ≤-pr a b (λ pr2 → pr (cong suc pr2)) 
≤-pr (suc a) (suc b) pr | inj₁ x = inj₁ (s≤s x)
≤-pr (suc a) (suc b) pr | inj₂ y = inj₂ (s≤s y)



≤-pr' : ∀ a b → a ≤ b ⊎ b ≤ a
≤-pr' zero b  = inj₁ z≤n
≤-pr' (suc a) zero  = inj₂ z≤n
≤-pr' (suc a) (suc b) with ≤-pr' a b  
≤-pr' (suc a) (suc b) | inj₁ x = inj₁ (s≤s x)
≤-pr' (suc a) (suc b) | inj₂ y = inj₂ (s≤s y)



+-ass : ∀ a b c → a + (b + c) ≡ a + b + c
+-ass zero b c = refl
+-ass (suc a) b c rewrite +-ass a b c  = refl

-self : ∀ a → a ∸ a ≡ 0
-self zero = refl
-self (suc a) = -self a

a+0 : ∀ a → a + 0 ≡ a
a+0 zero = refl
a+0 (suc a) rewrite a+0 a = refl


minuProp1 : ∀ a b → a ∸ b ≡ 0 → a ∸ (suc b) ≡ 0
minuProp1 zero b pr = refl
minuProp1 (suc a) zero ()
minuProp1 (suc a) (suc b) pr = minuProp1 a b pr


minuProp2 : ∀ a b n → a ∸ b ≡ (suc n) → a ∸ (suc b) ≡ n
minuProp2 zero zero n ()
minuProp2 zero (suc b) n ()
minuProp2 (suc a) zero n pr = cong pred pr
minuProp2 (suc a) (suc b) n pr = minuProp2 a b n pr


a+b : ∀ a b → a + b ≡ 0 → a ≡ 0
a+b zero b eq = refl
a+b (suc a) b ()

b+a : ∀ a b → a + b ≡ 0 → b ≡ 0
b+a zero b eq = eq
b+a (suc a) b ()


open import Data.Nat
refl≤ : ∀ x → x ≤ x
refl≤ zero = z≤n
refl≤ (suc x) = s≤s (refl≤ x)

trans≤ : ∀ x y z → x ≤ y → y ≤ z → x ≤ z
trans≤ .0 y z z≤n p2 = z≤n
trans≤ (suc x) (suc y) (suc z) (s≤s p1) (s≤s p2) = s≤s (trans≤  x y z p1 p2)

weak≤ : ∀ x y → x < y → x ≤ y
weak≤ x zero ()
weak≤ zero (suc y) p = z≤n
weak≤ (suc x) (suc y) (s≤s p) = s≤s (weak≤ x y p )

weakr≤ : ∀ x y → x ≤ y → x < suc y
weakr≤ zero zero p = s≤s z≤n
weakr≤ zero (suc y) p = s≤s z≤n
weakr≤ (suc x) zero ()
weakr≤ (suc x) (suc y) (s≤s p) = s≤s (weakr≤ x y p)

open import Data.Empty
⊥≤ : ∀ x → x < x → ⊥
⊥≤ zero ()
⊥≤ (suc x) (s≤s pr) = ⊥≤ x pr

open import Data.Sum
dec' : ∀ x y → x ≤ y ⊎ y < x
dec' zero y = inj₁ z≤n
dec' (suc x) zero = inj₂ (s≤s z≤n)
dec' (suc x) (suc y) with dec' x y 
dec' (suc x) (suc y) | inj₁ x₁ = inj₁ (s≤s x₁)
dec' (suc x) (suc y) | inj₂ y₁ = inj₂ (s≤s y₁)

--open import Logic
dec : ∀ x y → ¬ (x ≤ y) → y < x
dec x y p with dec' x y 
dec x y p | inj₁ x₁ with (p x₁)
... | ()
dec x y p | inj₂ y₁ = y₁ 

≤-o : ∀ x y → ¬ x ≤ y → y ≤ x
≤-o x zero p = z≤n
≤-o zero (suc y) p with (p z≤n)
... | ()
≤-o (suc x) (suc y) p = s≤s (≤-o x y (λ q → p (s≤s q)))
